/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.textfinder;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.plugins.textfinder.TextFinderChangeCondition;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class TextFinder
extends AbstractDescribableImpl<TextFinder>
implements Serializable {
    @NonNull
    private String regexp;
    @CheckForNull
    private String fileSet;
    @NonNull
    private String buildResult = Result.FAILURE.toString();
    private TextFinderChangeCondition changeCondition = TextFinderChangeCondition.MATCH_FOUND;
    private boolean alsoCheckConsoleOutput;
    private static final long serialVersionUID = 1L;

    @Restricted(value={NoExternalUse.class})
    public String getRegexp() {
        return this.regexp;
    }

    @DataBoundConstructor
    @Restricted(value={NoExternalUse.class})
    public TextFinder(String regexp) {
        this.regexp = Objects.requireNonNull(regexp);
    }

    @Restricted(value={NoExternalUse.class})
    void setRegexp(String regexp) {
        this.regexp = Objects.requireNonNull(regexp);
    }

    @Restricted(value={NoExternalUse.class})
    public String getFileSet() {
        return this.fileSet;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setFileSet(String fileSet) {
        this.fileSet = fileSet != null ? Util.fixEmpty((String)fileSet.trim()) : null;
    }

    @Restricted(value={NoExternalUse.class})
    public String getBuildResult() {
        return this.buildResult;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setBuildResult(String buildResult) {
        if (buildResult == null || Util.fixEmpty((String)buildResult.trim()) == null) {
            buildResult = Result.FAILURE.toString();
        }
        if (!buildResult.equalsIgnoreCase(Result.fromString((String)buildResult).toString())) {
            throw new IllegalArgumentException("buildResult is invalid: " + buildResult + ". Valid options are SUCCESS, UNSTABLE, FAILURE, NOT_BUILT and ABORTED.");
        }
        this.buildResult = buildResult;
    }

    @Restricted(value={NoExternalUse.class})
    public TextFinderChangeCondition getChangeCondition() {
        return this.changeCondition;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setChangeCondition(TextFinderChangeCondition changeCondition) {
        this.changeCondition = changeCondition;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isAlsoCheckConsoleOutput() {
        return this.alsoCheckConsoleOutput;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setAlsoCheckConsoleOutput(boolean alsoCheckConsoleOutput) {
        this.alsoCheckConsoleOutput = alsoCheckConsoleOutput;
    }

    protected Object readResolve() {
        if (this.changeCondition == null) {
            this.changeCondition = TextFinderChangeCondition.MATCH_FOUND;
        }
        return this;
    }

    @Symbol(value={"textFinder"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<TextFinder> {
        @NonNull
        public String getDisplayName() {
            return "";
        }

        public FormValidation doCheckRegexp(@QueryParameter String value) {
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.ok();
            }
            try {
                Pattern.compile(value);
                return FormValidation.ok();
            }
            catch (PatternSyntaxException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public ListBoxModel doFillBuildResultItems() {
            ListBoxModel r = new ListBoxModel();
            for (Result result : Arrays.asList(Result.SUCCESS, Result.UNSTABLE, Result.FAILURE, Result.NOT_BUILT, Result.ABORTED)) {
                r.add(result.toString());
            }
            return r;
        }
    }
}

