/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;

@SuppressFBWarnings(value={"NM_CLASS_NOT_EXCEPTION"}, justification="Not an exception, but represents one associated with a test result parsed by this plugin")
public class MethodResultException
implements Serializable {
    private String exceptionName;
    private String message;
    private String stackTrace;

    public MethodResultException(String exceptionName, String message, String shortStackTrace, String fullStackTrace) {
        this.message = message == null ? null : message.trim();
        this.exceptionName = exceptionName;
        this.trySettingData(shortStackTrace, fullStackTrace);
    }

    public String getExceptionName() {
        return this.exceptionName;
    }

    private void trySettingData(String shortStackTrace, String fullStackTrace) {
        String tmpStackTrace = shortStackTrace;
        if ((shortStackTrace == null || "".equals(shortStackTrace)) && fullStackTrace != null) {
            tmpStackTrace = fullStackTrace;
        }
        this.stackTrace = tmpStackTrace.trim();
        if (this.message == null) {
            int index = this.stackTrace.indexOf("\n");
            if (index != -1) {
                if (this.exceptionName == null || this.exceptionName.isEmpty()) {
                    this.exceptionName = this.stackTrace.substring(0, index);
                }
                this.stackTrace = this.stackTrace.substring(index + 1, this.stackTrace.length());
            }
        } else {
            this.message = this.message.trim();
            int index = this.stackTrace.indexOf(": ");
            if (index != -1) {
                if (this.exceptionName == null || this.exceptionName.isEmpty()) {
                    this.exceptionName = this.stackTrace.substring(0, index);
                }
                this.stackTrace = this.stackTrace.substring(index + 2, this.stackTrace.length()).replace(this.message, "");
            }
        }
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.exceptionName).append(": ");
        if (this.message != null) {
            str.append(this.message);
        }
        str.append("\n");
        str.append(this.stackTrace);
        return str.toString();
    }
}

