/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.results;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.testng.results.BaseResult;
import hudson.plugins.testng.results.GroupedTestRun;
import hudson.plugins.testng.results.MethodResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"}, justification="XStream does not care")
public class ClassResult
extends BaseResult {
    private String pkgName;
    private List<MethodResult> testMethodList = new ArrayList<MethodResult>();
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="HashMap is Serializable")
    private Map<String, GroupedTestRun> testRunMap = null;
    private transient long startTime;
    private transient long endTime;
    private transient int fail;
    private transient int skip;
    private transient int pass;

    public ClassResult(String pkgName, String name) {
        super(name);
        this.pkgName = pkgName;
    }

    public String getPkgName() {
        return this.pkgName;
    }

    public String getCanonicalName() {
        if ("No Package".equals(this.pkgName)) {
            return this.getName();
        }
        return this.pkgName + "." + this.getName();
    }

    public Map<String, GroupedTestRun> getTestRunMap() {
        if (this.testRunMap != null) {
            return this.testRunMap;
        }
        this.testRunMap = new HashMap<String, GroupedTestRun>();
        for (MethodResult methodResult : this.testMethodList) {
            GroupedTestRun group;
            String methodTestRunId = methodResult.getTestRunId();
            if (this.testRunMap.containsKey(methodTestRunId)) {
                group = this.testRunMap.get(methodTestRunId);
            } else {
                group = new GroupedTestRun(methodTestRunId, methodResult.getParentTestName(), methodResult.getParentSuiteName());
                this.testRunMap.put(methodTestRunId, group);
            }
            if (methodResult.isConfig()) {
                group.addConfigurationMethod(methodResult);
                continue;
            }
            group.addTestMethod(methodResult);
        }
        return this.testRunMap;
    }

    @Override
    public void setRun(Run<?, ?> run) {
        super.setRun(run);
        for (MethodResult _m : this.testMethodList) {
            _m.setRun(run);
        }
    }

    @Exported
    public float getDuration() {
        return (float)(this.endTime - this.startTime) / 1000.0f;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    @Exported(visibility=9, name="fail")
    public int getFailCount() {
        return this.fail;
    }

    @Exported(visibility=9, name="skip")
    public int getSkipCount() {
        return this.skip;
    }

    @Exported(visibility=9)
    public int getTotalCount() {
        return super.getTotalCount();
    }

    public int getPassCount() {
        return this.pass;
    }

    public void addTestMethods(List<MethodResult> list) {
        this.testMethodList.addAll(list);
    }

    public void tally() {
        this.fail = 0;
        this.skip = 0;
        this.pass = 0;
        this.startTime = Long.MAX_VALUE;
        this.endTime = 0L;
        HashMap<String, Integer> methodInstanceMap = new HashMap<String, Integer>();
        for (MethodResult methodResult : this.testMethodList) {
            long timestamp;
            if (!methodResult.isConfig()) {
                if ("FAIL".equals(methodResult.getStatus())) {
                    ++this.fail;
                } else if ("SKIP".equals(methodResult.getStatus())) {
                    ++this.skip;
                } else {
                    ++this.pass;
                }
            }
            if ((timestamp = methodResult.getStartTime()) != -1L && this.startTime > timestamp) {
                this.startTime = timestamp;
            }
            if ((timestamp = methodResult.getEndTime()) != -1L && this.endTime < timestamp) {
                this.endTime = timestamp;
            }
            methodResult.setParent(this);
            String methodName = methodResult.getName();
            if (methodInstanceMap.containsKey(methodName)) {
                int currIdx = (Integer)methodInstanceMap.get(methodName);
                methodResult.setTestUuid(String.valueOf(++currIdx));
                methodInstanceMap.put(methodName, currIdx);
                continue;
            }
            methodInstanceMap.put(methodName, 0);
        }
    }

    @Override
    public Object getDynamic(String token, StaplerRequest2 req, StaplerResponse2 rsp) {
        if (this.testMethodList != null) {
            for (MethodResult methodResult : this.testMethodList) {
                if (!token.equals(methodResult.getSafeName())) continue;
                return methodResult;
            }
        }
        return null;
    }

    @Exported(name="test-method")
    public List<MethodResult> getTestMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public List<MethodResult> getConfigurationMethods() {
        ArrayList<MethodResult> list = new ArrayList<MethodResult>();
        for (MethodResult methodResult : this.testMethodList) {
            if (!methodResult.isConfig()) continue;
            list.add(methodResult);
        }
        return list;
    }

    public List<MethodResult> getChildren() {
        return this.testMethodList;
    }

    public boolean hasChildren() {
        return this.testMethodList != null && !this.testMethodList.isEmpty();
    }
}

