/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.util;

public class FormatUtil {
    public static final String MORE_THAN_24HRS = "> 24hrs";
    private static final long HOUR_IN_SEC = 3600L;
    private static final long MIN_IN_SEC = 60L;

    private FormatUtil() {
    }

    public static String formatTime(float duration) {
        if (duration / 86400.0f > 1.0f) {
            return MORE_THAN_24HRS;
        }
        try {
            byte hours = (byte)(duration / 3600.0f);
            byte minutes = (byte)((duration -= (float)((long)hours * 3600L)) / 60.0f);
            byte seconds = (byte)(duration -= (float)((long)minutes * 60L));
            int milliseconds = Math.round((duration -= (float)seconds) * 1000.0f);
            return "%02d:%02d:%02d.%03d".formatted(hours, minutes, seconds, milliseconds);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "-1";
        }
    }

    public static String formatLong(long value) {
        if (value == 0L) {
            return "0";
        }
        if (value < 0L) {
            return Long.toString(value);
        }
        return "+" + Long.toString(value);
    }

    public static String escapeString(String str) {
        if (str == null) {
            return "";
        }
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\"", "&quot;");
        str = str.replace("\n", "<br/>");
        return str;
    }

    public static String escapeJS(String str) {
        if (str == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(str.length() + 64);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                buf.append("&lt;");
                continue;
            }
            if (ch == '>') {
                buf.append("&gt;");
                continue;
            }
            if (ch == '&') {
                buf.append("&amp;");
                continue;
            }
            if (ch == '\'') {
                buf.append("&apos;");
                continue;
            }
            if (ch == '\"') {
                buf.append("&quot;");
                continue;
            }
            if (ch == ':') {
                buf.append("&#58;");
                continue;
            }
            if (ch == '%') {
                buf.append("&#37;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String formatStackTraceForHTML(String stackTrace) {
        return FormatUtil.escapeString(stackTrace);
    }
}

