/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.testng.TestNGTestResultBuildAction;
import hudson.plugins.testng.results.TestNGResult;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

public class Publisher
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(Publisher.class.getName());
    private String reportFilenamePattern = "**/testng-results.xml";
    private boolean escapeTestDescp = true;
    private boolean escapeExceptionMsg = true;
    private boolean failureOnFailedTestConfig = false;
    private boolean showFailedBuilds = false;
    @Deprecated
    public transient boolean unstableOnSkippedTests;
    private Integer unstableSkips = 100;
    private Integer unstableFails = 0;
    private Integer failedSkips = 100;
    private Integer failedFails = 100;
    private Integer thresholdMode = 2;
    private static final boolean ALLOW_UNESCAPED_HTML;
    private static boolean allowUnescapedHTML;
    @Extension
    public static final DescriptorImpl DESCRIPTOR;

    static void setAllowUnescapedHTML(boolean value) {
        allowUnescapedHTML = value;
    }

    static boolean getAllowUnescapedHTML() {
        return allowUnescapedHTML;
    }

    @DataBoundConstructor
    public Publisher() {
    }

    public String getReportFilenamePattern() {
        return this.reportFilenamePattern;
    }

    @DataBoundSetter
    public void setReportFilenamePattern(String reportFilenamePattern) {
        this.reportFilenamePattern = reportFilenamePattern;
    }

    public boolean getEscapeTestDescp() {
        if (allowUnescapedHTML) {
            return this.escapeTestDescp;
        }
        return true;
    }

    @DataBoundSetter
    public void setEscapeTestDescp(boolean escapeTestDescp) {
        this.escapeTestDescp = allowUnescapedHTML ? escapeTestDescp : true;
    }

    public boolean getEscapeExceptionMsg() {
        if (allowUnescapedHTML) {
            return this.escapeExceptionMsg;
        }
        return true;
    }

    @DataBoundSetter
    public void setEscapeExceptionMsg(boolean escapeExceptionMsg) {
        this.escapeExceptionMsg = allowUnescapedHTML ? escapeExceptionMsg : true;
    }

    public boolean getFailureOnFailedTestConfig() {
        return this.failureOnFailedTestConfig;
    }

    @DataBoundSetter
    public void setFailureOnFailedTestConfig(boolean failureOnFailedTestConfig) {
        this.failureOnFailedTestConfig = failureOnFailedTestConfig;
    }

    public boolean getShowFailedBuilds() {
        return this.showFailedBuilds;
    }

    @DataBoundSetter
    public void setShowFailedBuilds(boolean showFailedBuilds) {
        this.showFailedBuilds = showFailedBuilds;
    }

    public Integer getUnstableSkips() {
        return this.unstableSkips;
    }

    @DataBoundSetter
    public void setUnstableSkips(Integer unstableSkips) {
        this.unstableSkips = unstableSkips;
    }

    public Integer getUnstableFails() {
        return this.unstableFails;
    }

    @DataBoundSetter
    public void setUnstableFails(Integer unstableFails) {
        this.unstableFails = unstableFails;
    }

    public Integer getFailedSkips() {
        return this.failedSkips;
    }

    @DataBoundSetter
    public void setFailedSkips(Integer failedSkips) {
        this.failedSkips = failedSkips;
    }

    public Integer getFailedFails() {
        return this.failedFails;
    }

    @DataBoundSetter
    public void setFailedFails(Integer failedFails) {
        this.failedFails = failedFails;
    }

    public Integer getThresholdMode() {
        return this.thresholdMode;
    }

    @DataBoundSetter
    public void setThresholdMode(Integer thresholdMode) {
        this.thresholdMode = thresholdMode;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public BuildStepDescriptor<hudson.tasks.Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        String pathsPattern;
        PrintStream logger = listener.getLogger();
        if (Result.ABORTED.equals(build.getResult())) {
            logger.println("Build Aborted. Not looking for any TestNG results.");
            return;
        }
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            EnvVars env = build.getEnvironment(listener);
            env.overrideAll(abstractBuild.getBuildVariables());
            pathsPattern = env.expand(this.reportFilenamePattern);
        } else {
            pathsPattern = this.reportFilenamePattern;
        }
        logger.println("TestNG Reports Processing: START");
        logger.println("Looking for TestNG results report in workspace using pattern: " + pathsPattern);
        FilePath[] paths = Publisher.locateReports(workspace, pathsPattern);
        if (paths.length == 0) {
            logger.println("Did not find any matching files.");
            return;
        }
        paths = Publisher.checkReports(build, paths, logger);
        boolean filesSaved = Publisher.saveReports(Publisher.getTestNGReport(build), paths, logger);
        if (!filesSaved) {
            logger.println("Failed to save TestNG XML reports");
            return;
        }
        TestNGResult results = new TestNGResult();
        try {
            results = TestNGTestResultBuildAction.loadResults(build, logger);
        }
        catch (Throwable t) {
            t.printStackTrace(logger);
        }
        if (results.getTestList().size() > 0) {
            build.addAction((Action)new TestNGTestResultBuildAction(results, this.escapeTestDescp, this.escapeExceptionMsg, this.showFailedBuilds));
            if (this.failureOnFailedTestConfig && results.getFailedConfigCount() > 0) {
                logger.println("Failed configuration methods found. Marking build as FAILURE.");
                build.setResult(Result.FAILURE);
            } else if (this.thresholdMode == 1) {
                if (results.getFailCount() > this.failedFails) {
                    logger.println("%d tests failed, which exceeded threshold of %d. Marking build as FAILURE".formatted(results.getFailCount(), this.failedFails));
                    build.setResult(Result.FAILURE);
                } else if (results.getSkipCount() > this.failedSkips) {
                    logger.println("%d tests were skipped, which exceeded threshold of %d. Marking build as FAILURE".formatted(results.getSkipCount(), this.failedSkips));
                    build.setResult(Result.FAILURE);
                } else if (results.getFailCount() > this.unstableFails) {
                    logger.println("%d tests failed, which exceeded threshold of %d. Marking build as UNSTABLE".formatted(results.getFailCount(), this.unstableFails));
                    build.setResult(Result.UNSTABLE);
                } else if (results.getSkipCount() > this.unstableSkips) {
                    logger.println("%d tests were skipped, which exceeded threshold of %d. Marking build as UNSTABLE".formatted(results.getSkipCount(), this.unstableSkips));
                    build.setResult(Result.UNSTABLE);
                }
            } else if (this.thresholdMode == 2) {
                float failedPercent = (float)(100 * results.getFailCount()) / (float)results.getTotalCount();
                float skipPercent = (float)(100 * results.getSkipCount()) / (float)results.getTotalCount();
                if (failedPercent > (float)this.failedFails.intValue()) {
                    logger.println("%f%% of tests failed, which exceeded threshold of %d%%. Marking build as FAILURE".formatted(Float.valueOf(failedPercent), this.failedFails));
                    build.setResult(Result.FAILURE);
                } else if (skipPercent > (float)this.failedSkips.intValue()) {
                    logger.println("%f%% of tests were skipped, which exceeded threshold of %d%%. Marking build as FAILURE".formatted(Float.valueOf(skipPercent), this.failedSkips));
                    build.setResult(Result.FAILURE);
                } else if (failedPercent > (float)this.unstableFails.intValue()) {
                    logger.println("%f%% of tests failed, which exceeded threshold of %d%%. Marking build as UNSTABLE".formatted(Float.valueOf(failedPercent), this.unstableFails));
                    build.setResult(Result.UNSTABLE);
                } else if (skipPercent > (float)this.unstableSkips.intValue()) {
                    logger.println("%f%% of tests were skipped, which exceeded threshold of %d%%. Marking build as UNSTABLE".formatted(Float.valueOf(skipPercent), this.unstableSkips));
                    build.setResult(Result.UNSTABLE);
                }
            } else {
                RuntimeException e = new RuntimeException("Invalid threshold type: " + this.thresholdMode);
                e.printStackTrace(logger);
            }
        } else {
            logger.println("Found matching files but did not find any TestNG results.");
            return;
        }
        logger.println("TestNG Reports Processing: FINISH");
    }

    protected Object readResolve() {
        if (this.unstableSkips == null) {
            this.unstableSkips = this.unstableOnSkippedTests ? 0 : 100;
        }
        if (this.unstableFails == null) {
            this.unstableFails = 0;
        }
        if (this.failedFails == null) {
            this.failedFails = 100;
        }
        if (this.failedSkips == null) {
            this.failedSkips = 100;
        }
        if (this.thresholdMode == null) {
            this.thresholdMode = 2;
        }
        return this;
    }

    static FilePath[] locateReports(FilePath workspace, String filenamePattern) throws IOException, InterruptedException {
        String[] parts;
        try {
            FilePath[] ret = workspace.list(filenamePattern);
            if (ret.length > 0) {
                return ret;
            }
        }
        catch (Exception ret) {
            // empty catch block
        }
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String path : parts = filenamePattern.split("\\s*[;:,]+\\s*")) {
            FilePath src = workspace.child(path);
            if (!src.exists()) continue;
            if (src.isDirectory()) {
                files.addAll(Arrays.asList(src.list("**/testng*.xml")));
                continue;
            }
            files.add(src);
        }
        return files.toArray(new FilePath[files.size()]);
    }

    static FilePath getTestNGReport(Run<?, ?> build) {
        return new FilePath(new File(build.getRootDir(), "testng"));
    }

    static FilePath[] checkReports(Run<?, ?> build, FilePath[] paths, PrintStream logger) {
        ArrayList<FilePath> filePathList = new ArrayList<FilePath>(paths.length);
        for (FilePath report : paths) {
            try {
                if (build.getTimestamp().getTimeInMillis() / 1000L <= report.lastModified() / 1000L) {
                    filePathList.add(report);
                    continue;
                }
                logger.println(report.getName() + " was last modified before this build started. Ignoring it.");
            }
            catch (IOException e) {
                e.printStackTrace(logger);
            }
            catch (InterruptedException e) {
                e.printStackTrace(logger);
            }
        }
        return filePathList.toArray(new FilePath[0]);
    }

    static boolean saveReports(FilePath testngDir, FilePath[] paths, PrintStream logger) {
        logger.println("Saving reports...");
        try {
            testngDir.mkdirs();
            int i = 0;
            for (FilePath report : paths) {
                String name = "testng-results" + (String)(i > 0 ? "-" + i : "") + ".xml";
                ++i;
                FilePath dst = testngDir.child(name);
                report.copyTo(dst);
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            return false;
        }
        return true;
    }

    static {
        allowUnescapedHTML = ALLOW_UNESCAPED_HTML = Boolean.valueOf(System.getProperty("hudson.plugins.testng.Publisher.allowUnescapedHTML", "false")).booleanValue();
        if (ALLOW_UNESCAPED_HTML) {
            LOGGER.log(Level.WARNING, "You are vulnerable to a cross-site scripting attack through the TestNG plugin. Remove the system property hudson.plugins.testng.Publisher.allowUnescapedHTML from your Jenkins controller startup.");
        }
        DESCRIPTOR = new DescriptorImpl();
    }

    @Symbol(value={"testNG"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<hudson.tasks.Publisher> {
        private DescriptorImpl() {
            super(Publisher.class);
        }

        public String getDisplayName() {
            return "Publish TestNG Results";
        }

        public hudson.tasks.Publisher newInstance(@NonNull StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (hudson.tasks.Publisher)req.bindJSON(Publisher.class, formData);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        private FormValidation validate(String value) {
            try {
                int val = Integer.parseInt(value);
                if (val < 0) {
                    return FormValidation.error((String)"Value should be greater than 0");
                }
                if (val > 100) {
                    return FormValidation.ok((String)"NOTE: value greater than 100 only make sense when Threshold Mode is set to 'Number of Tests'");
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException ex) {
                return FormValidation.error((String)"value should be an integer");
            }
        }

        @POST
        public FormValidation doCheckUnstableSkips(@QueryParameter String value) {
            return this.validate(value);
        }

        @POST
        public FormValidation doCheckUnstableFails(@QueryParameter String value) {
            return this.validate(value);
        }

        @POST
        public FormValidation doCheckFailedSkips(@QueryParameter String value) {
            return this.validate(value);
        }

        @POST
        public FormValidation doCheckFailedFails(@QueryParameter String value) {
            return this.validate(value);
        }
    }
}

