/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng.parser;

import hudson.FilePath;
import hudson.Util;
import hudson.plugins.testng.results.ClassResult;
import hudson.plugins.testng.results.MethodResult;
import hudson.plugins.testng.results.MethodResultException;
import hudson.plugins.testng.results.TestNGResult;
import hudson.plugins.testng.results.TestNGTestResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class ResultsParser {
    private static final Logger log = Logger.getLogger(ResultsParser.class.getName());
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final XmlPullParserFactory PARSER_FACTORY = ResultsParser.createParserFactory();
    private final DateFormat dateFormat;
    private PrintStream logger;
    private Map<String, TestNGTestResult> testResultMap = new HashMap<String, TestNGTestResult>();
    private Map<String, ClassResult> classResultMap = new HashMap<String, ClassResult>();
    private StringBuilder reporterOutputBuilder;
    private Map<String, List<String>> methodGroupMap = new HashMap<String, List<String>>();
    private TestNGResult finalResults;
    private List<TestNGTestResult> testList;
    private List<ClassResult> currentClassList;
    private List<MethodResult> currentMethodList;
    private List<String> currentMethodParamsList;
    private TestNGTestResult currentTest;
    private ClassResult currentClass;
    private String currentTestRunId;
    private MethodResult currentMethod;
    private XmlPullParser xmlPullParser;
    private TAGS currentCDATAParent = TAGS.UNKNOWN;
    private String currentMessage;
    private String currentShortStackTrace;
    private String currentFullStackTrace;
    private String currentGroupName;
    private String currentSuite;
    private String currentLine;
    private String exceptionName;

    private static XmlPullParserFactory createParserFactory() {
        try {
            XmlPullParserFactory f = XmlPullParserFactory.newInstance();
            f.setNamespaceAware(true);
            f.setValidating(false);
            return f;
        }
        catch (XmlPullParserException e) {
            log.severe(e.toString());
            return null;
        }
    }

    public ResultsParser() {
        this.dateFormat = new SimpleDateFormat(DATE_FORMAT);
    }

    public ResultsParser(PrintStream logger) {
        this();
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestNGResult parse(FilePath[] paths) {
        if (null == paths) {
            this.log("File paths not specified. paths var is null. Returning empty test results.");
            return new TestNGResult();
        }
        this.finalResults = new TestNGResult();
        for (FilePath path : paths) {
            File file = new File(path.getRemote());
            if (!file.isFile()) {
                this.log("'" + file.getAbsolutePath() + "' points to an invalid test report");
                continue;
            }
            this.log("Processing '" + file.getAbsolutePath() + "'");
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                this.xmlPullParser = this.createXmlPullParser(bufferedInputStream);
                this.testList = new ArrayList<TestNGTestResult>();
                while (1 != this.xmlPullParser.nextToken()) {
                    TAGS tag = TAGS.fromString(this.xmlPullParser.getName());
                    int eventType = this.xmlPullParser.getEventType();
                    block9 : switch (eventType) {
                        case 2: {
                            switch (tag.ordinal()) {
                                case 1: {
                                    this.startSuite(this.get("name"));
                                    break block9;
                                }
                                case 13: {
                                    this.startGroups();
                                    break block9;
                                }
                                case 14: {
                                    this.startGroup(this.get("name"));
                                    break block9;
                                }
                                case 15: {
                                    this.startGroupMethod(this.get("class"), this.get("name"));
                                    break block9;
                                }
                                case 2: {
                                    this.startTest(this.get("name"));
                                    break block9;
                                }
                                case 3: {
                                    this.startClass(this.get("name"));
                                    break block9;
                                }
                                case 4: {
                                    this.startTestMethod(this.get("name"), this.get("test-instance-name"), this.get("status"), this.get("description"), this.get("duration-ms"), this.get("started-at"), this.get("is-config"));
                                    break block9;
                                }
                                case 16: {
                                    this.startReporterOutput();
                                    break block9;
                                }
                                case 17: {
                                    this.startLine();
                                    this.currentCDATAParent = TAGS.LINE;
                                    break block9;
                                }
                                case 5: {
                                    this.startMethodParameters();
                                    this.currentCDATAParent = TAGS.PARAMS;
                                    break block9;
                                }
                                case 8: {
                                    this.startException(this.get("class"));
                                    break block9;
                                }
                                case 10: {
                                    this.currentCDATAParent = TAGS.MESSAGE;
                                    break block9;
                                }
                                case 11: {
                                    this.currentCDATAParent = TAGS.SHORT_STACKTRACE;
                                    break block9;
                                }
                                case 12: {
                                    this.currentCDATAParent = TAGS.FULL_STACKTRACE;
                                    break block9;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (tag.ordinal()) {
                                case 1: {
                                    this.finishSuite();
                                    break block9;
                                }
                                case 14: {
                                    this.finishGroup();
                                    break block9;
                                }
                                case 15: {
                                    this.finishGroupMethod();
                                    break block9;
                                }
                                case 2: {
                                    this.finishTest();
                                    break block9;
                                }
                                case 3: {
                                    this.finishClass();
                                    break block9;
                                }
                                case 4: {
                                    this.finishTestMethod();
                                    break block9;
                                }
                                case 16: {
                                    this.endReporterOutput();
                                    break block9;
                                }
                                case 17: {
                                    this.endLine();
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                    break block9;
                                }
                                case 5: {
                                    this.finishMethodParameters();
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                    break block9;
                                }
                                case 8: {
                                    this.finishException();
                                    break block9;
                                }
                                case 10: 
                                case 11: 
                                case 12: {
                                    this.currentCDATAParent = TAGS.UNKNOWN;
                                    break block9;
                                }
                            }
                            break;
                        }
                        case 5: {
                            this.handleCDATA();
                            break;
                        }
                    }
                }
                this.finalResults.addUniqueTests(this.testList);
            }
            catch (XmlPullParserException e) {
                this.log("Failed to parse XML: " + e.getMessage());
                this.log((Exception)((Object)e));
            }
            catch (FileNotFoundException e) {
                this.log("Failed to find XML file");
                this.log(e);
            }
            catch (IOException e) {
                this.log(e);
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException e) {
                    this.log(e);
                }
            }
        }
        this.finalResults.tally();
        return this.finalResults;
    }

    private void startLine() {
        if (this.currentMethod != null && this.reporterOutputBuilder == null) {
            this.reporterOutputBuilder = new StringBuilder("");
        }
    }

    private void endLine() {
        if (this.currentMethod != null) {
            this.reporterOutputBuilder.append(Util.escape((String)this.currentLine)).append("<br/>");
        }
    }

    private void startReporterOutput() {
    }

    private void endReporterOutput() {
        if (this.currentMethod != null && this.reporterOutputBuilder != null) {
            this.currentMethod.setReporterOutput(this.reporterOutputBuilder.toString());
        }
        this.reporterOutputBuilder = null;
    }

    private void startGroupMethod(String className, String methodName) {
        String key = className + "|" + methodName;
        List<String> groups = this.methodGroupMap.get(key);
        if (groups == null) {
            groups = new ArrayList<String>(3);
            groups.add(this.currentGroupName);
            this.methodGroupMap.put(key, groups);
        } else {
            groups.add(this.currentGroupName);
        }
    }

    private void finishGroupMethod() {
    }

    private void startGroup(String groupName) {
        this.currentGroupName = groupName;
    }

    private void finishGroup() {
        this.currentGroupName = null;
    }

    private void startGroups() {
        this.methodGroupMap = new HashMap<String, List<String>>();
    }

    private void startSuite(String name) {
        this.currentSuite = name;
    }

    private void finishSuite() {
        this.methodGroupMap.clear();
        this.currentSuite = null;
    }

    private void startException(String exceptionName) {
        this.exceptionName = exceptionName;
    }

    private void finishException() {
        MethodResultException mrEx = new MethodResultException(this.exceptionName, this.currentMessage, this.currentShortStackTrace, this.currentFullStackTrace);
        this.currentMethod.setException(mrEx);
        mrEx = null;
        this.currentMessage = null;
        this.currentShortStackTrace = null;
        this.currentFullStackTrace = null;
        this.exceptionName = null;
    }

    private void startMethodParameters() {
        this.currentMethodParamsList = new ArrayList<String>();
    }

    private void finishMethodParameters() {
        this.currentMethod.setParameters(this.currentMethodParamsList);
        this.currentMethodParamsList = null;
    }

    private void handleCDATA() {
        switch (this.currentCDATAParent.ordinal()) {
            case 5: {
                this.currentMethodParamsList.add(this.xmlPullParser.getText());
                break;
            }
            case 10: {
                this.currentMessage = this.xmlPullParser.getText();
                break;
            }
            case 12: {
                this.currentFullStackTrace = this.xmlPullParser.getText();
                break;
            }
            case 11: {
                this.currentShortStackTrace = this.xmlPullParser.getText();
                break;
            }
            case 17: {
                this.currentLine = this.xmlPullParser.getText();
                break;
            }
        }
    }

    private void startTestMethod(String name, String testInstanceName, String status, String description, String duration, String startedAt, String isConfig) {
        Date startedAtDate = null;
        try {
            startedAtDate = this.dateFormat.parse(startedAt);
        }
        catch (ParseException e) {
            this.log("Unable to parse started-at value: " + startedAt);
        }
        this.currentMethod = new MethodResult(name, status, description, duration, startedAtDate == null ? -1L : startedAtDate.getTime(), isConfig, this.currentTestRunId, this.currentTest.getName(), this.currentSuite, testInstanceName);
        List<String> groups = this.methodGroupMap.get(this.currentClass.getCanonicalName() + "|" + name);
        if (groups != null) {
            this.currentMethod.setGroups(groups);
        }
    }

    private void finishTestMethod() {
        this.updateTestMethodLists(this.currentMethod);
        this.currentMethodList.add(this.currentMethod);
        this.currentMethod = null;
    }

    private void startClass(String name) {
        String pkgName;
        int idx = name.lastIndexOf(46);
        String simpleName = idx == -1 ? name : name.substring(idx + 1, name.length());
        String string = pkgName = idx == -1 ? "No Package" : name.substring(0, idx);
        if (this.classResultMap.containsKey(name)) {
            this.currentClass = this.classResultMap.get(name);
        } else {
            this.currentClass = new ClassResult(pkgName, simpleName);
            this.classResultMap.put(name, this.currentClass);
        }
        this.currentMethodList = new ArrayList<MethodResult>();
        this.currentTestRunId = UUID.randomUUID().toString();
    }

    private void finishClass() {
        this.currentClass.addTestMethods(this.currentMethodList);
        this.currentClassList.add(this.currentClass);
        this.currentMethodList = null;
        this.currentClass = null;
        this.currentTestRunId = null;
    }

    private void startTest(String name) {
        if (this.testResultMap.containsKey(name)) {
            this.currentTest = this.testResultMap.get(name);
        } else {
            this.currentTest = new TestNGTestResult(name);
            this.testResultMap.put(name, this.currentTest);
        }
        this.currentClassList = new ArrayList<ClassResult>();
    }

    private void finishTest() {
        this.currentTest.addClassList(this.currentClassList);
        this.testList.add(this.currentTest);
        this.currentClassList = null;
        this.currentTest = null;
    }

    private void updateTestMethodLists(MethodResult testMethod) {
        if (testMethod.isConfig()) {
            if ("FAIL".equals(testMethod.getStatus())) {
                this.finalResults.getFailedConfigs().add(testMethod);
            } else if ("SKIP".equals(testMethod.getStatus())) {
                this.finalResults.getSkippedConfigs().add(testMethod);
            }
        } else if ("FAIL".equals(testMethod.getStatus())) {
            this.finalResults.getFailedTests().add(testMethod);
        } else if ("SKIP".equals(testMethod.getStatus())) {
            this.finalResults.getSkippedTests().add(testMethod);
        } else if ("PASS".equals(testMethod.getStatus())) {
            this.finalResults.getPassedTests().add(testMethod);
        }
    }

    private String get(String attr) {
        return this.xmlPullParser.getAttributeValue(null, attr);
    }

    private XmlPullParser createXmlPullParser(BufferedInputStream bufferedInputStream) throws XmlPullParserException {
        if (PARSER_FACTORY == null) {
            throw new XmlPullParserException("XML Parser Factory has not been initialized properly");
        }
        XmlPullParser parser = PARSER_FACTORY.newPullParser();
        parser.setInput((InputStream)bufferedInputStream, null);
        return parser;
    }

    private void log(String str) {
        if (this.logger != null) {
            this.logger.println(str);
        } else {
            log.fine(str);
        }
    }

    private void log(Exception ex) {
        if (this.logger != null) {
            ex.printStackTrace(this.logger);
        } else {
            log.severe(ex.toString());
        }
    }

    private static enum TAGS {
        TESTNG_RESULTS,
        SUITE,
        TEST,
        CLASS,
        TEST_METHOD,
        PARAMS,
        PARAM,
        VALUE,
        EXCEPTION,
        UNKNOWN,
        MESSAGE,
        SHORT_STACKTRACE,
        FULL_STACKTRACE,
        GROUPS,
        GROUP,
        METHOD,
        REPORTER_OUTPUT,
        LINE;


        public static TAGS fromString(String val) {
            if (val == null) {
                return UNKNOWN;
            }
            val = val.toUpperCase().replace('-', '_');
            try {
                return TAGS.valueOf(val);
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

