/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.testng;

import hudson.Functions;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.testng.Publisher;
import hudson.plugins.testng.TestNGTestResultBuildAction;
import hudson.plugins.testng.util.GraphHelper;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import hudson.util.Graph;
import java.io.IOException;
import java.util.Calendar;
import java.util.SortedMap;
import jenkins.model.lazy.LazyBuildMixIn;
import org.jfree.chart.JFreeChart;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class TestNGProjectAction
extends TestResultProjectAction
implements ProminentProjectAction {
    private transient boolean escapeTestDescp;
    private transient boolean escapeExceptionMsg;
    private transient boolean showFailedBuilds;

    public TestNGProjectAction(Job<?, ?> project, boolean escapeTestDescp, boolean escapeExceptionMsg, boolean showFailedBuilds) {
        super(project);
        if (Publisher.getAllowUnescapedHTML()) {
            this.escapeExceptionMsg = escapeExceptionMsg;
            this.escapeTestDescp = escapeTestDescp;
        } else {
            this.escapeExceptionMsg = true;
            this.escapeTestDescp = true;
        }
        this.showFailedBuilds = showFailedBuilds;
    }

    protected Class<TestNGTestResultBuildAction> getBuildActionClass() {
        return TestNGTestResultBuildAction.class;
    }

    public boolean getEscapeTestDescp() {
        if (Publisher.getAllowUnescapedHTML()) {
            return this.escapeTestDescp;
        }
        return true;
    }

    public boolean getEscapeExceptionMsg() {
        if (Publisher.getAllowUnescapedHTML()) {
            return this.escapeExceptionMsg;
        }
        return true;
    }

    public Job<?, ?> getProject() {
        return this.job;
    }

    public String getIconFileName() {
        return "/plugin/testng-plugin/icons/report.png";
    }

    public String getDisplayName() {
        return "TestNG Results";
    }

    public String getGraphName() {
        return "TestNG Results Trend";
    }

    public String getUrlName() {
        return "testngreports";
    }

    public String getSearchUrl() {
        return "testngreports";
    }

    public void doGraph(final StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(this, -1L, this.getGraphWidth(), this.getGraphHeight()){
            final /* synthetic */ TestNGProjectAction this$0;
            {
                this.this$0 = this$0;
                super(timestamp, defaultWidth, defaultHeight);
            }

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doPng(req, rsp);
    }

    public String getUpUrl() {
        return Functions.getNearestAncestorUrl((StaplerRequest2)Stapler.getCurrentRequest2(), (Object)this.job) + "/";
    }

    private boolean newGraphNotNeeded(StaplerRequest2 req, StaplerResponse2 rsp) {
        Calendar t = this.getProject().getLastCompletedBuild().getTimestamp();
        return req.checkIfModified(t, rsp);
    }

    public void doGraphMap(final StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        if (this.newGraphNotNeeded(req, rsp)) {
            return;
        }
        final DataSetBuilder dataSetBuilder = new DataSetBuilder();
        this.populateDataSetBuilder((DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dataSetBuilder);
        new Graph(this, -1L, this.getGraphWidth(), this.getGraphHeight()){
            final /* synthetic */ TestNGProjectAction this$0;
            {
                this.this$0 = this$0;
                super(timestamp, defaultWidth, defaultHeight);
            }

            protected JFreeChart createGraph() {
                return GraphHelper.createChart(req, dataSetBuilder.build());
            }
        }.doMap(req, rsp);
    }

    public boolean isGraphActive() {
        Run build = this.getProject().getLastBuild();
        int numPoints = 0;
        while (numPoints < 2) {
            if (build == null) {
                return false;
            }
            if (build.getAction(this.getBuildActionClass()) != null) {
                ++numPoints;
            }
            build = build.getPreviousBuild();
        }
        return true;
    }

    public TestNGTestResultBuildAction getLastCompletedBuildAction() {
        for (Run build = this.getProject().getLastCompletedBuild(); build != null; build = build.getPreviousCompletedBuild()) {
            TestNGTestResultBuildAction action = (TestNGTestResultBuildAction)build.getAction(this.getBuildActionClass());
            if (action == null) continue;
            return action;
        }
        return null;
    }

    protected void populateDataSetBuilder(DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel> dataset) {
        if (!(this.job instanceof LazyBuildMixIn.LazyLoadingJob)) {
            return;
        }
        SortedMap loadedBuilds = ((LazyBuildMixIn.LazyLoadingJob)this.job).getLazyBuildMixIn()._getRuns().getLoadedBuilds();
        for (Run build : loadedBuilds.values()) {
            ChartUtil.NumberOnlyBuildLabel label = new ChartUtil.NumberOnlyBuildLabel(build);
            TestNGTestResultBuildAction action = (TestNGTestResultBuildAction)build.getAction(this.getBuildActionClass());
            Result result = build.getResult();
            if (result == null || result.isWorseThan(Result.FAILURE) || !this.showFailedBuilds && result.equals(Result.FAILURE) || action == null) continue;
            dataset.add((Number)(action.getTotalCount() - action.getFailCount() - action.getSkipCount()), (Comparable)((Object)"Passed"), (Comparable)label);
            dataset.add((Number)action.getFailCount(), (Comparable)((Object)"Failed"), (Comparable)label);
            dataset.add((Number)action.getSkipCount(), (Comparable)((Object)"Skipped"), (Comparable)label);
        }
    }

    public int getGraphWidth() {
        return 500;
    }

    public int getGraphHeight() {
        return 200;
    }
}

