/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer.result.info;

import hudson.tasks.test.TabulatedResult;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.PackageInfo;

public class ResultInfo {
    private Map<String, PackageInfo> packageResults = new TreeMap<String, PackageInfo>();

    public void addPackage(Integer buildNumber, TabulatedResult packageResult, String url) {
        PackageInfo packageInfo;
        String packageName = packageResult.getName();
        if (this.packageResults.containsKey(packageName)) {
            packageInfo = this.packageResults.get(packageName);
        } else {
            packageInfo = new PackageInfo();
            packageInfo.setName(packageName);
        }
        packageInfo.putPackageResult(buildNumber, packageResult, url + this.getResultUrl(packageResult) + "/" + packageResult.getSafeName());
        this.packageResults.put(packageName, packageInfo);
    }

    public Map<String, PackageInfo> getPackageResults() {
        return this.packageResults;
    }

    protected String getResultUrl(TabulatedResult result) {
        boolean isTestng = result.getClass().getName().startsWith("hudson.plugins.testng.results");
        if (isTestng) {
            return "testngreports";
        }
        return "testReport";
    }
}

