/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer.result.info;

import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestResult;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.testresultsanalyzer.result.data.PackageResultData;
import org.jenkinsci.plugins.testresultsanalyzer.result.data.ResultData;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.ClassInfo;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.Info;

public class PackageInfo
extends Info {
    protected Map<String, ClassInfo> classes = new TreeMap<String, ClassInfo>();

    public void putPackageResult(Integer buildNumber, TabulatedResult packageResult, String url) {
        PackageResultData packageResultData = new PackageResultData((TestResult)packageResult, url);
        this.addClasses(buildNumber, packageResult, url);
        this.buildResults.put(buildNumber, packageResultData);
    }

    public ResultData getPackageResult(Integer buildNumber) {
        if (this.buildResults.containsKey(buildNumber)) {
            return (ResultData)this.buildResults.get(buildNumber);
        }
        return null;
    }

    public Map<String, ClassInfo> getClasses() {
        return this.classes;
    }

    public void addClasses(Integer buildNumber, TabulatedResult packageResult, String url) {
        for (TestResult classResult : packageResult.getChildren()) {
            ClassInfo classInfo;
            String className = classResult.getName();
            if (this.classes.containsKey(className)) {
                classInfo = this.classes.get(className);
            } else {
                classInfo = new ClassInfo();
                classInfo.setName(className);
            }
            classInfo.putBuildClassResult(buildNumber, (TabulatedResult)classResult, url + "/" + classResult.getSafeName());
            this.classes.put(className, classInfo);
        }
    }

    public Map<String, ClassInfo> getChildren() {
        return this.classes;
    }
}

