/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer.result.info;

import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestResult;
import java.util.Map;
import java.util.TreeMap;
import org.jenkinsci.plugins.testresultsanalyzer.result.data.ClassResultData;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.Info;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.TestCaseInfo;

public class ClassInfo
extends Info {
    private Map<String, TestCaseInfo> tests = new TreeMap<String, TestCaseInfo>();

    public void putBuildClassResult(Integer buildNumber, TabulatedResult classResult, String url) {
        ClassResultData classResultData = new ClassResultData(classResult, url);
        this.addTests(buildNumber, classResult, url);
        this.buildResults.put(buildNumber, classResultData);
    }

    public Map<String, TestCaseInfo> getTests() {
        return this.tests;
    }

    private void addTests(Integer buildNumber, TabulatedResult classResult, String url) {
        for (TestResult testCaseResult : classResult.getChildren()) {
            TestCaseInfo testCaseInfo;
            String testCaseName = testCaseResult.getDisplayName();
            if (this.tests.containsKey(testCaseName)) {
                testCaseInfo = this.tests.get(testCaseName);
            } else {
                testCaseInfo = new TestCaseInfo();
                testCaseInfo.setName(testCaseName);
            }
            testCaseInfo.putTestCaseResult(buildNumber, testCaseResult, url + "/" + testCaseResult.getSafeName());
            this.tests.put(testCaseName, testCaseInfo);
        }
    }

    public Map<String, TestCaseInfo> getChildren() {
        return this.tests;
    }
}

