/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.model.TransientActionFactory;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.testresultsanalyzer.TestResultsAnalyzerAction;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class TestResultsAnalyzerExtension
extends TransientActionFactory<Job>
implements Describable<TestResultsAnalyzerExtension> {
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @NonNull
    public Collection<? extends Action> createFor(@NonNull Job target) {
        return Collections.singleton(new TestResultsAnalyzerAction(target));
    }

    public Class<Job> type() {
        return Job.class;
    }

    public Descriptor<TestResultsAnalyzerExtension> getDescriptor() {
        return DESCRIPTOR;
    }

    public static class DescriptorImpl
    extends Descriptor<TestResultsAnalyzerExtension> {
        private static final String PASSED_STATUS_COLOR = "#92D050";
        private static final String FAILED_STATUS_COLOR = "#F37A7A";
        private static final String SKIP_STATUS_COLOR = "#FDED72";
        private static final String NA_STATUS_COLOR = "#E8F5FF";
        private static final String PASSED_REPRESENTATION = "PASSED";
        private static final String FAILED_REPRESENTATION = "FAILED";
        private static final String SKIPPED_REPRESENTATION = "SKIPPED";
        private static final String NA_REPRESENTATION = "N/A";
        private String noOfBuilds = "10";
        private int noOfRunsToFetch = -1;
        private boolean showAllBuilds = false;
        private boolean showBuildTime = false;
        private boolean showLineGraph = true;
        private boolean showBarGraph = true;
        private boolean showPieGraph = true;
        private boolean hideConfigurationMethods = false;
        private String runTimeLowThreshold = "0.5";
        private String runTimeHighThreshold = "1.0";
        private static final String passFailString = "passfail";
        private static final String runtimeString = "runtime";
        private boolean useCustomStatusNames;
        private String passedRepresentation = "PASSED";
        private String failedRepresentation = "FAILED";
        private String skippedRepresentation = "SKIPPED";
        private String naRepresentation = "N/A";
        private boolean useCustomStatusColors;
        private String passedColor = "#92D050";
        private String failedColor = "#F37A7A";
        private String skippedColor = "#FDED72";
        private String naColor = "#E8F5FF";
        private String chartDataType = "passfail";

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Test Results Analyzer";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) {
            try {
                JSONObject customData;
                this.noOfBuilds = formData.getString("noOfBuilds");
                this.noOfRunsToFetch = formData.getInt("noOfRunsToFetch");
                this.showAllBuilds = formData.getBoolean("showAllBuilds");
                this.showBuildTime = formData.getBoolean("showBuildTime");
                this.hideConfigurationMethods = formData.getBoolean("hideConfigurationMethods");
                this.showLineGraph = formData.getBoolean("showLineGraph");
                this.showBarGraph = formData.getBoolean("showBarGraph");
                this.showPieGraph = formData.getBoolean("showPieGraph");
                this.runTimeLowThreshold = formData.getString("runTimeLowThreshold");
                this.runTimeHighThreshold = formData.getString("runTimeHighThreshold");
                this.chartDataType = formData.getString("chartDataType");
                if (formData.containsKey((Object)"useCustomStatusNames")) {
                    customData = formData.getJSONObject("useCustomStatusNames");
                    this.useCustomStatusNames = true;
                    this.passedRepresentation = customData.getString("passedRepresentation");
                    this.failedRepresentation = customData.getString("failedRepresentation");
                    this.skippedRepresentation = customData.getString("skippedRepresentation");
                    this.naRepresentation = customData.getString("naRepresentation");
                } else {
                    this.useCustomStatusNames = false;
                    this.passedRepresentation = PASSED_REPRESENTATION;
                    this.failedRepresentation = FAILED_REPRESENTATION;
                    this.skippedRepresentation = SKIPPED_REPRESENTATION;
                    this.naRepresentation = NA_REPRESENTATION;
                }
                if (formData.containsKey((Object)"useCustomStatusColors")) {
                    customData = formData.getJSONObject("useCustomStatusColors");
                    this.useCustomStatusColors = true;
                    this.passedColor = customData.getString("passedColor");
                    this.failedColor = customData.getString("failedColor");
                    this.skippedColor = customData.getString("skippedColor");
                    this.naColor = customData.getString("naColor");
                } else {
                    this.useCustomStatusColors = false;
                    this.passedColor = PASSED_STATUS_COLOR;
                    this.failedColor = FAILED_STATUS_COLOR;
                    this.skippedColor = SKIP_STATUS_COLOR;
                    this.naColor = NA_STATUS_COLOR;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.save();
            return true;
        }

        public String getNoOfBuilds() {
            return this.noOfBuilds;
        }

        public int getNoOfRunsToFetch() {
            return this.noOfRunsToFetch;
        }

        public boolean getShowAllBuilds() {
            return this.showAllBuilds;
        }

        public boolean getShowLineGraph() {
            return this.showLineGraph;
        }

        public boolean getShowBarGraph() {
            return this.showBarGraph;
        }

        public boolean getShowPieGraph() {
            return this.showPieGraph;
        }

        public boolean getHideConfigurationMethods() {
            return this.hideConfigurationMethods;
        }

        public boolean getShowBuildTime() {
            return this.showBuildTime;
        }

        public String getRunTimeLowThreshold() {
            return this.runTimeLowThreshold;
        }

        public String getRunTimeHighThreshold() {
            return this.runTimeHighThreshold;
        }

        public String getChartDataType() {
            return this.chartDataType;
        }

        public String getPassFailString() {
            return passFailString;
        }

        public String getRuntimeString() {
            return runtimeString;
        }

        public String getPassedRepresentation() {
            return this.passedRepresentation;
        }

        public boolean isUseCustomStatusNames() {
            return this.useCustomStatusNames;
        }

        public String getFailedRepresentation() {
            return this.failedRepresentation;
        }

        public String getSkippedRepresentation() {
            return this.skippedRepresentation;
        }

        public String getNaRepresentation() {
            return this.naRepresentation;
        }

        public boolean isUseCustomStatusColors() {
            return this.useCustomStatusColors;
        }

        public String getPassedColor() {
            return this.passedColor;
        }

        public String getFailedColor() {
            return this.failedColor;
        }

        public String getSkippedColor() {
            return this.skippedColor;
        }

        public String getNaColor() {
            return this.naColor;
        }

        public FormValidation doCheckNoOfRunsToFetch(@QueryParameter String noOfRunsToFetch) {
            return this.intValidation(noOfRunsToFetch);
        }

        public FormValidation doCheckNoOfBuilds(@QueryParameter String noOfBuilds) {
            return this.intValidation(noOfBuilds);
        }

        public FormValidation doCheckPassedRepresentation(@QueryParameter String passedRepresentation) {
            return this.valueValidation(passedRepresentation);
        }

        public FormValidation doCheckFailedRepresentation(@QueryParameter String failedRepresentation) {
            return this.valueValidation(failedRepresentation);
        }

        public FormValidation doCheckSkippedRepresentation(@QueryParameter String skippedRepresentation) {
            return this.valueValidation(skippedRepresentation);
        }

        public FormValidation doCheckNaRepresentation(@QueryParameter String naRepresentation) {
            return this.valueValidation(naRepresentation);
        }

        private FormValidation intValidation(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Entered value should not be empty");
            }
            try {
                Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Entered value is not a number. Please enter a valid number.");
            }
            return FormValidation.ok();
        }

        private FormValidation valueValidation(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Entered value should not be empty");
            }
            Pattern regex = Pattern.compile("[<>{}*\\\"'$&+,:;=?@#|]");
            Matcher matcher = regex.matcher(value);
            if (matcher.find()) {
                return FormValidation.error((String)"Entered value should not have special characters.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassedColor(@QueryParameter String passedColor) {
            return this.colorValidation(passedColor);
        }

        public FormValidation doCheckFailedColor(@QueryParameter String failedColor) {
            return this.colorValidation(failedColor);
        }

        public FormValidation doCheckSkippedColor(@QueryParameter String skippedColor) {
            return this.colorValidation(skippedColor);
        }

        public FormValidation doCheckNaColor(@QueryParameter String naColor) {
            return this.colorValidation(naColor);
        }

        private FormValidation colorValidation(String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Entered value should not be empty");
            }
            String HEX_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
            Pattern regex = Pattern.compile("^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$");
            Matcher matcher = regex.matcher(value);
            if (!matcher.matches()) {
                return FormValidation.error((String)"Entered value should be a valid HEX Color");
            }
            return FormValidation.ok();
        }
    }
}

