/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer;

import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.testresultsanalyzer.result.data.ResultData;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.Info;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.PackageInfo;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.ResultInfo;

public class JsTreeUtil {
    public JSONObject getJsTree(List<Integer> builds, ResultInfo resultInfo, boolean hideConfigMethods) {
        JSONObject tree = new JSONObject();
        JSONArray buildJson = new JSONArray();
        for (Integer buildNumber : builds) {
            buildJson.add((Object)buildNumber.toString());
        }
        tree.put("builds", (Object)buildJson);
        JSONArray results = new JSONArray();
        for (Map.Entry<String, PackageInfo> entry : resultInfo.getPackageResults().entrySet()) {
            results.add((Object)this.createJson(builds, entry.getValue(), hideConfigMethods));
        }
        tree.put("results", (Object)results);
        return tree;
    }

    private JSONObject createJson(List<Integer> builds, Info info, boolean hideConfigMethods) {
        JSONObject baseJson = new JSONObject();
        baseJson.put("text", (Object)info.getName());
        baseJson.put("buildResults", (Object)this.getBuilds(builds, info));
        baseJson.put("children", (Object)this.getChildren(builds, info, hideConfigMethods));
        return baseJson;
    }

    private JSONArray getBuilds(List<Integer> builds, Info info) {
        JSONArray treeDataJson = new JSONArray();
        for (Integer buildNumber : builds) {
            treeDataJson.add((Object)this.getBuild(buildNumber, info));
        }
        return treeDataJson;
    }

    private JSONArray getChildren(List<Integer> builds, Info info, boolean hideConfigMethods) {
        Map<String, ? extends Info> childrenInfo = info.getChildren();
        if (childrenInfo == null) {
            return new JSONArray();
        }
        JSONArray children = new JSONArray();
        for (Map.Entry<String, ? extends Info> entry : childrenInfo.entrySet()) {
            if (hideConfigMethods && entry.getValue().isConfig()) continue;
            children.add((Object)this.createJson(builds, entry.getValue(), hideConfigMethods));
        }
        return children;
    }

    private JSONObject getBuild(Integer buildNumber, Info info) {
        JSONObject json = new JSONObject();
        json.put("buildNumber", (Object)buildNumber.toString());
        ResultData result = info.getBuildResult(buildNumber);
        if (result == null) {
            json.put("status", (Object)"N/A");
        } else {
            json.put("totalTests", (Object)result.getTotalTests());
            json.put("totalFailed", (Object)result.getTotalFailed());
            json.put("totalPassed", (Object)result.getTotalPassed());
            json.put("totalSkipped", (Object)result.getTotalSkipped());
            json.put("totalTimeTaken", (Object)Float.valueOf(result.getTotalTimeTaken()));
            json.put("status", (Object)result.getStatus());
            json.put("url", (Object)result.getUrl());
        }
        return json;
    }
}

