/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer.result.data;

import hudson.tasks.test.TestResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.jenkinsci.plugins.testresultsanalyzer.result.data.ResultData;

public class TestCaseResultData
extends ResultData {
    public TestCaseResultData(TestResult testResult, String url) {
        this.setName(testResult.getName());
        boolean doTestNg = testResult.getClass().getName().equals("hudson.plugins.testng.results.MethodResult");
        if (doTestNg) {
            try {
                Method configMethod;
                Object configReturnValue;
                Method statusMethod = testResult.getClass().getMethod("getStatus", new Class[0]);
                Object statusReturnValue = statusMethod.invoke((Object)testResult, new Object[0]);
                if (statusReturnValue instanceof String) {
                    String status = ((String)statusReturnValue).toLowerCase(Locale.ENGLISH);
                    this.setTotalTests(1);
                    this.setTotalFailed(status.startsWith("fail") ? 1 : 0);
                    this.setTotalPassed(status.startsWith("pass") ? 1 : 0);
                    this.setTotalSkipped(status.startsWith("skip") ? 1 : 0);
                }
                if ((configReturnValue = (configMethod = testResult.getClass().getMethod("isConfig", new Class[0])).invoke((Object)testResult, new Object[0])) instanceof Boolean) {
                    boolean isConfig = (Boolean)configReturnValue;
                    this.setConfig(isConfig);
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                doTestNg = false;
            }
        }
        if (!doTestNg) {
            this.setTotalTests(testResult.getTotalCount());
            this.setTotalFailed(testResult.getFailCount());
            this.setTotalPassed(testResult.getPassCount());
            this.setTotalSkipped(testResult.getSkipCount());
        }
        this.setTotalTimeTaken(testResult.getDuration());
        this.setUrl(url);
        this.evaluateStatus();
    }
}

