/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.testresultsanalyzer;

import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.AggregatedTestResultAction;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestResult;
import hudson.util.RunList;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.testresultsanalyzer.JsTreeUtil;
import org.jenkinsci.plugins.testresultsanalyzer.ResultStatus;
import org.jenkinsci.plugins.testresultsanalyzer.TestResultsAnalyzerExtension;
import org.jenkinsci.plugins.testresultsanalyzer.config.UserConfig;
import org.jenkinsci.plugins.testresultsanalyzer.result.data.ResultData;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.ClassInfo;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.PackageInfo;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.ResultInfo;
import org.jenkinsci.plugins.testresultsanalyzer.result.info.TestCaseInfo;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class TestResultsAnalyzerAction
extends Actionable
implements Action {
    Job project;
    private List<Integer> builds = new ArrayList<Integer>();
    private static final Logger LOG = Logger.getLogger(TestResultsAnalyzerAction.class.getName());
    ResultInfo resultInfo;

    public TestResultsAnalyzerAction(Job project) {
        this.project = project;
    }

    public final String getDisplayName() {
        return this.hasPermission() ? "Test Results Analyzer" : null;
    }

    public final String getIconFileName() {
        return this.hasPermission() ? "/plugin/test-results-analyzer/images/icon.png" : null;
    }

    public String getUrlName() {
        return this.hasPermission() ? "test_results_analyzer" : null;
    }

    public String getSearchUrl() {
        return this.hasPermission() ? "test_results_analyzer" : null;
    }

    private boolean hasPermission() {
        return this.project.hasPermission(Item.READ);
    }

    public Job getProject() {
        return this.project;
    }

    @JavaScriptMethod
    public JSONArray getNoOfBuilds(String noOfbuildsNeeded) {
        int noOfBuilds = this.getNoOfBuildRequired(noOfbuildsNeeded);
        JSONArray jsonArray = this.getBuildsArray(this.getBuildList(noOfBuilds));
        return jsonArray;
    }

    private JSONArray getBuildsArray(List<Integer> buildList) {
        JSONArray jsonArray = new JSONArray();
        for (Integer build : buildList) {
            jsonArray.add((Object)build);
        }
        return jsonArray;
    }

    private List<Integer> getBuildList(int noOfBuilds) {
        if (noOfBuilds <= 0 || noOfBuilds >= this.builds.size()) {
            return this.builds;
        }
        ArrayList<Integer> buildList = new ArrayList<Integer>();
        for (int i = 0; i < noOfBuilds; ++i) {
            buildList.add(this.builds.get(i));
        }
        return buildList;
    }

    private int getNoOfBuildRequired(String noOfbuildsNeeded) {
        int noOfBuilds;
        try {
            noOfBuilds = Integer.parseInt(noOfbuildsNeeded);
        }
        catch (NumberFormatException e) {
            noOfBuilds = -1;
        }
        return noOfBuilds;
    }

    public boolean isUpdated() {
        Run lastBuild = this.project.getLastBuild();
        if (lastBuild == null) {
            return false;
        }
        int latestBuildNumber = lastBuild.getNumber();
        return !this.builds.contains(latestBuildNumber);
    }

    public void getJsonLoadData() {
        if (!this.isUpdated()) {
            return;
        }
        this.resultInfo = new ResultInfo();
        this.builds = new ArrayList<Integer>();
        RunList runs = null;
        runs = this.getNoOfRunsToFetch() > 0 ? this.project.getBuilds().limit(this.getNoOfRunsToFetch()) : this.project.getBuilds();
        for (Run run : runs) {
            if (run.isBuilding()) continue;
            int buildNumber = run.getNumber();
            this.builds.add(buildNumber);
            List testActions = run.getActions(AbstractTestResultAction.class);
            for (AbstractTestResultAction testAction : testActions) {
                if (AggregatedTestResultAction.class.isInstance(testAction)) {
                    this.addTestResults(buildNumber, (AggregatedTestResultAction)testAction);
                    continue;
                }
                this.addTestResult(buildNumber, run, testAction, testAction.getResult());
            }
        }
    }

    private void addTestResults(int buildNumber, AggregatedTestResultAction testAction) {
        List childReports = testAction.getChildReports();
        for (AggregatedTestResultAction.ChildReport childReport : childReports) {
            this.addTestResult(buildNumber, childReport.run, (AbstractTestResultAction)testAction, childReport.result);
        }
    }

    private void addTestResult(int buildNumber, Run run, AbstractTestResultAction testAction, Object result) {
        if (run == null || result == null) {
            return;
        }
        try {
            TabulatedResult testResult = (TabulatedResult)result;
            Collection packageResults = testResult.getChildren();
            Jenkins jenkins = Jenkins.getInstance();
            String rootUrl = jenkins != null ? jenkins.getRootUrl() : "";
            for (TestResult packageResult : packageResults) {
                this.resultInfo.addPackage(buildNumber, (TabulatedResult)packageResult, rootUrl + run.getUrl());
            }
        }
        catch (ClassCastException e) {
            LOG.info("Got ClassCast exception while converting results to Tabulated Result from action: " + testAction.getClass().getName() + ". Ignoring as we only want test results for processing.");
        }
    }

    @JavaScriptMethod
    public JSONObject getTreeResult(UserConfig userConfig) {
        if (this.resultInfo == null) {
            return new JSONObject();
        }
        int noOfBuilds = this.getNoOfBuildRequired(userConfig.getNoOfBuildsNeeded());
        List<Integer> buildList = this.getBuildList(noOfBuilds);
        JsTreeUtil jsTreeUtils = new JsTreeUtil();
        return jsTreeUtils.getJsTree(buildList, this.resultInfo, userConfig.isHideConfigMethods());
    }

    @JavaScriptMethod
    public String getExportCSV(String timeBased, String noOfBuildsNeeded) {
        boolean isTimeBased = Boolean.parseBoolean(timeBased);
        Map<String, PackageInfo> packageResults = this.resultInfo.getPackageResults();
        int noOfBuilds = this.getNoOfBuildRequired(noOfBuildsNeeded);
        List<Integer> buildList = this.getBuildList(noOfBuilds);
        StringBuffer builder = new StringBuffer("");
        for (int i = 0; i < buildList.size(); ++i) {
            builder.append(",\"");
            builder.append(Integer.toString(this.builds.get(i)));
            builder.append("\"");
        }
        Object header = "\"Package\",\"Class\",\"Test\"";
        header = (String)header + builder.toString();
        StringBuilder exportBuilder = new StringBuilder();
        exportBuilder.append((String)header + System.lineSeparator());
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        decimalFormat.setRoundingMode(RoundingMode.CEILING);
        for (PackageInfo pInfo : packageResults.values()) {
            String packageName = pInfo.getName();
            for (ClassInfo cInfo : pInfo.getClasses().values()) {
                String className = cInfo.getName();
                for (TestCaseInfo tInfo : cInfo.getTests().values()) {
                    String testName = tInfo.getName();
                    exportBuilder.append("\"" + packageName + "\",\"" + className + "\",\"" + testName + "\"");
                    Map<Integer, ResultData> buildPackageResults = tInfo.getBuildPackageResults();
                    for (int i = 0; i < buildList.size(); ++i) {
                        Integer buildNumber = buildList.get(i);
                        String data = this.getCustomStatus("NA");
                        if (buildPackageResults.containsKey(buildNumber)) {
                            ResultData buildResult = buildPackageResults.get(buildNumber);
                            data = !isTimeBased ? this.getCustomStatus(buildResult.getStatus()) : decimalFormat.format(buildResult.getTotalTimeTaken());
                        }
                        exportBuilder.append(",\"" + data + "\"");
                    }
                    exportBuilder.append(System.lineSeparator());
                }
            }
        }
        return exportBuilder.toString();
    }

    private String getCustomStatus(String status) {
        ResultStatus resultStatus = null;
        try {
            resultStatus = ResultStatus.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            resultStatus = null;
        }
        if (resultStatus == null) {
            return status;
        }
        switch (resultStatus) {
            case PASSED: {
                return this.getPassedRepresentation();
            }
            case FAILED: {
                return this.getFailedRepresentation();
            }
            case SKIPPED: {
                return this.getSkippedRepresentation();
            }
            case NA: {
                return this.getNaRepresentation();
            }
        }
        return status;
    }

    public String getNoOfBuilds() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getNoOfBuilds();
    }

    public int getNoOfRunsToFetch() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getNoOfRunsToFetch();
    }

    public boolean getShowAllBuilds() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getShowAllBuilds();
    }

    public boolean getShowLineGraph() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getShowLineGraph();
    }

    public boolean getShowBarGraph() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getShowBarGraph();
    }

    public boolean getShowPieGraph() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getShowPieGraph();
    }

    public boolean getShowBuildTime() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getShowBuildTime();
    }

    public boolean getHideConfigurationMethods() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getHideConfigurationMethods();
    }

    public String getChartDataType() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getChartDataType();
    }

    public String getRunTimeLowThreshold() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getRunTimeLowThreshold();
    }

    public String getRunTimeHighThreshold() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getRunTimeHighThreshold();
    }

    public boolean isUseCustomStatusNames() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.isUseCustomStatusNames();
    }

    public String getPassedRepresentation() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getPassedRepresentation();
    }

    public String getFailedRepresentation() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getFailedRepresentation();
    }

    public String getSkippedRepresentation() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getSkippedRepresentation();
    }

    public String getNaRepresentation() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getNaRepresentation();
    }

    public String getPassedColor() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getPassedColor();
    }

    public String getFailedColor() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getFailedColor();
    }

    public String getSkippedColor() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getSkippedColor();
    }

    public String getNaColor() {
        return TestResultsAnalyzerExtension.DESCRIPTOR.getNaColor();
    }
}

