/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import com.google.common.primitives.Primitives;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Result;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.structs.describable.ArrayType;
import org.jenkinsci.plugins.structs.describable.AtomicType;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.EnumType;
import org.jenkinsci.plugins.structs.describable.ErrorType;
import org.jenkinsci.plugins.structs.describable.HeterogeneousObjectType;
import org.jenkinsci.plugins.structs.describable.HomogeneousObjectType;
import org.jvnet.tiger_types.Types;

public abstract class ParameterType {
    @NonNull
    private final Type actualType;
    private static final Logger LOGGER = Logger.getLogger(ParameterType.class.getName());

    public Type getActualType() {
        return this.actualType;
    }

    ParameterType(Type actualType) {
        this.actualType = actualType;
    }

    static ParameterType of(Type type) {
        try {
            if (type instanceof Class) {
                Class c = (Class)type;
                if (c == String.class || Primitives.unwrap((Class)c).isPrimitive()) {
                    return new AtomicType(c);
                }
                if (Enum.class.isAssignableFrom(c)) {
                    ArrayList<String> constants = new ArrayList<String>();
                    for (Enum value : c.asSubclass(Enum.class).getEnumConstants()) {
                        constants.add(value.name());
                    }
                    return new EnumType(c, constants.toArray(new String[constants.size()]));
                }
                if (c == URL.class) {
                    return new AtomicType(String.class);
                }
                if (c == Result.class) {
                    return new AtomicType(String.class);
                }
                if (c.isArray()) {
                    return new ArrayType(c);
                }
                Set<Class<?>> subtypes = DescribableModel.findSubtypes(c);
                if (subtypes.isEmpty() && !Modifier.isAbstract(c.getModifiers()) || subtypes.equals(Collections.singleton(c))) {
                    return new HomogeneousObjectType(c);
                }
                HashMap subtypesBySimpleName = new HashMap();
                for (Class<?> subtype : subtypes) {
                    String simpleName = subtype.getSimpleName();
                    ArrayList bySimpleName = (ArrayList)subtypesBySimpleName.get(simpleName);
                    if (bySimpleName == null) {
                        bySimpleName = new ArrayList();
                        subtypesBySimpleName.put(simpleName, bySimpleName);
                    }
                    bySimpleName.add(subtype);
                }
                TreeMap types = new TreeMap();
                for (Map.Entry entry : subtypesBySimpleName.entrySet()) {
                    if (((List)entry.getValue()).size() == 1) {
                        try {
                            types.put((String)entry.getKey(), DescribableModel.of((Class)((List)entry.getValue()).get(0)));
                        }
                        catch (Exception x) {
                            LOGGER.log(Level.FINE, x, () -> "skipping subtype " + ((Class)((List)entry.getValue()).get(0)).getName());
                        }
                        catch (NoClassDefFoundError x) {
                            LOGGER.log(Level.WARNING, x, () -> "skipping subtype " + ((Class)((List)entry.getValue()).get(0)).getName());
                        }
                        continue;
                    }
                    for (Class subtype : (List)entry.getValue()) {
                        try {
                            types.put(subtype.getName(), DescribableModel.of(subtype));
                        }
                        catch (Exception x) {
                            LOGGER.log(Level.FINE, x, () -> "skipping subtype " + subtype.getName());
                        }
                        catch (NoClassDefFoundError x) {
                            LOGGER.log(Level.WARNING, x, () -> "skipping subtype " + subtype.getName());
                        }
                    }
                }
                return new HeterogeneousObjectType(c, types);
            }
            if (Types.isSubClassOf((Type)type, Collection.class)) {
                return new ArrayType(type, ParameterType.of(Types.getTypeArgument((Type)Types.getBaseClass((Type)type, Collection.class), (int)0, Object.class)));
            }
            throw new UnsupportedOperationException("do not know how to categorize attributes of type " + String.valueOf(type));
        }
        catch (Exception x) {
            return new ErrorType(x, type);
        }
    }

    abstract void toString(StringBuilder var1, Stack<Class<?>> var2);

    public final String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b, new Stack());
        return b.toString();
    }
}

