/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.structs.describable;

import java.util.Map;
import java.util.Stack;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.ParameterType;

public final class HeterogeneousObjectType
extends ParameterType {
    private final Map<String, DescribableModel<?>> types;

    HeterogeneousObjectType(Class<?> supertype, Map<String, DescribableModel<?>> types) {
        super(supertype);
        this.types = types;
    }

    public Class<?> getType() {
        return (Class)this.getActualType();
    }

    public Map<String, DescribableModel<?>> getTypes() {
        return this.types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void toString(StringBuilder b, Stack<Class<?>> modelTypes) {
        Class<?> type = this.getType();
        b.append(type.getSimpleName());
        if (modelTypes.contains(type)) {
            b.append('\u2026');
        } else {
            modelTypes.push(type);
            try {
                b.append('{');
                boolean first = true;
                for (Map.Entry<String, DescribableModel<?>> entry : this.types.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(" | ");
                    }
                    String key = entry.getKey();
                    DescribableModel<?> model = entry.getValue();
                    if (!key.equals(model.getType().getSimpleName())) {
                        b.append(key).append('~');
                    }
                    model.toString(b, modelTypes);
                }
                b.append('}');
            }
            finally {
                modelTypes.pop();
            }
        }
    }
}

