/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.strictcrumbissuer;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.ModelObject;
import hudson.model.User;
import hudson.security.csrf.CrumbIssuer;
import hudson.security.csrf.CrumbIssuerDescriptor;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.concurrent.GuardedBy;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import jenkins.security.HexStringConfidentialKey;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;

public class StrictCrumbIssuer
extends CrumbIssuer {
    static final String HEADER_X_FORWARDED_FOR = "X-Forwarded-For";
    private static final String HEADER_REFERER = "Referer";
    private static final int MAX_HOURS_VALID = 24;
    private static final int TEMPORAL_VALIDATION_DISABLED = 0;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final int INCREMENTS_PER_HOUR = 12;
    private static final String MD_NAME = "SHA-256";
    private static final int MD_LENGTH = 64;
    private static final SecureRandom RANDOM = new SecureRandom();
    @GuardedBy(value="this")
    private transient MessageDigest md;
    private boolean checkClientIP;
    private boolean checkSameSource;
    private boolean checkOnlyLocalPath;
    private boolean checkSessionMatch;
    private boolean xorMasking;
    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="The synchronization is done for `md`")
    private int hoursValid;
    private static final Logger LOGGER = Logger.getLogger(StrictCrumbIssuer.class.getName());

    public StrictCrumbIssuer(boolean checkClientIP, boolean checkSameSource, boolean checkOnlyLocalPath, boolean checkSessionMatch, int hoursValid, boolean xorMasking) {
        this.checkClientIP = checkClientIP;
        this.checkSameSource = checkSameSource;
        this.checkOnlyLocalPath = checkOnlyLocalPath;
        this.checkSessionMatch = checkSessionMatch;
        this.hoursValid = hoursValid;
        this.xorMasking = xorMasking;
        this.ensureHoursValidIsInBoundaries();
        this.initMessageDigest();
    }

    @DataBoundConstructor
    public StrictCrumbIssuer() {
        this.checkClientIP = false;
        this.checkSameSource = false;
        this.checkOnlyLocalPath = false;
        this.checkSessionMatch = true;
        this.hoursValid = 2;
        this.xorMasking = true;
    }

    @DataBoundSetter
    public void setCheckClientIP(boolean checkClientIP) {
        this.checkClientIP = checkClientIP;
    }

    @DataBoundSetter
    public void setCheckSameSource(boolean checkSameSource) {
        this.checkSameSource = checkSameSource;
    }

    @DataBoundSetter
    public void setCheckOnlyLocalPath(boolean checkOnlyLocalPath) {
        this.checkOnlyLocalPath = checkOnlyLocalPath;
    }

    @DataBoundSetter
    public void setCheckSessionMatch(boolean checkSessionMatch) {
        this.checkSessionMatch = checkSessionMatch;
    }

    @DataBoundSetter
    public void setHoursValid(int hoursValid) {
        this.hoursValid = hoursValid;
    }

    @DataBoundSetter
    public void setXorMasking(boolean xorMasking) {
        this.xorMasking = xorMasking;
    }

    @Restricted(value={NoExternalUse.class})
    @PostConstruct
    public void setup() {
        this.ensureHoursValidIsInBoundaries();
        this.initMessageDigest();
    }

    private Object readResolve() {
        this.ensureHoursValidIsInBoundaries();
        this.initMessageDigest();
        return this;
    }

    private synchronized void initMessageDigest() {
        try {
            this.md = MessageDigest.getInstance(MD_NAME);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)"Can't find SHA-256");
        }
    }

    private void ensureHoursValidIsInBoundaries() {
        if (this.hoursValid > 24) {
            LOGGER.log(Level.WARNING, "The hoursValid (" + this.hoursValid + ") is too big, it will be reduced to 24");
            this.hoursValid = 24;
        } else if (this.hoursValid < 0) {
            LOGGER.log(Level.WARNING, "The hoursValid (" + this.hoursValid + ") is too small, the duration validation will be deactivated.");
            this.hoursValid = 0;
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.0")
    public boolean isCheckingClientIP() {
        return this.checkClientIP;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.0")
    public boolean isCheckingSameSource() {
        return this.checkSameSource;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.0")
    public boolean isCheckingOnlyLocalPath() {
        return this.checkOnlyLocalPath;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="2.1.0")
    public boolean isCheckingSessionMatch() {
        return this.checkSessionMatch;
    }

    public boolean isCheckClientIP() {
        return this.checkClientIP;
    }

    public boolean isCheckSameSource() {
        return this.checkSameSource;
    }

    public boolean isCheckOnlyLocalPath() {
        return this.checkOnlyLocalPath;
    }

    public boolean isCheckSessionMatch() {
        return this.checkSessionMatch;
    }

    public int getHoursValid() {
        return this.hoursValid;
    }

    public boolean isXorMasking() {
        return this.xorMasking;
    }

    @CheckForNull
    protected synchronized String issueCrumb(@NonNull ServletRequest request, @NonNull String salt) {
        if (request instanceof HttpServletRequest && this.md != null) {
            HttpServletRequest req = (HttpServletRequest)request;
            String sourceUrl = this.urlForCreation(req);
            String crumb = this.createCrumb(request, salt, this.getCurrentHour(), sourceUrl);
            return this.encodeCrumb(crumb);
        }
        return null;
    }

    public synchronized boolean validateCrumb(@NonNull ServletRequest request, @NonNull String salt, @CheckForNull String encodedCrumb) {
        if (request instanceof HttpServletRequest) {
            if (encodedCrumb != null) {
                String crumb = this.decodeCrumb(encodedCrumb);
                byte[] crumbBytes = crumb.getBytes(StandardCharsets.US_ASCII);
                HttpServletRequest req = (HttpServletRequest)request;
                String sourceUrl = this.urlForValidation(req);
                if (this.hoursValid == 0) {
                    if (this.isCrumbValid(request, salt, 0L, crumbBytes, sourceUrl)) {
                        return true;
                    }
                } else {
                    long hours = this.getCurrentHour();
                    int numOfIncrements = 12 * this.getHoursValid();
                    for (int i = 0; i <= numOfIncrements; ++i) {
                        if (!this.isCrumbValid(request, salt, hours - (long)i, crumbBytes, sourceUrl)) continue;
                        return true;
                    }
                }
                Level level = Jenkins.getAuthentication2() instanceof AnonymousAuthenticationToken ? Level.FINE : Level.WARNING;
                LOGGER.log(level, "Invalid crumb found in the request from user " + String.valueOf(User.current()) + " at path " + req.getPathInfo());
            } else {
                LOGGER.log(Level.FINER, "No crumb available in the request");
            }
        } else {
            LOGGER.log(Level.WARNING, "Passed request not a HttpServletRequest");
        }
        return false;
    }

    private boolean isCrumbValid(@NonNull ServletRequest request, @NonNull String salt, long hours, @NonNull byte[] actualCrumbBytes, @CheckForNull String sourceUrl) {
        String newCrumb = this.createCrumb(request, salt, hours, sourceUrl);
        byte[] newCrumbBytes = newCrumb.getBytes(StandardCharsets.US_ASCII);
        return MessageDigest.isEqual(newCrumbBytes, actualCrumbBytes);
    }

    long getCurrentHour() {
        return new Date().getTime() / 300000L;
    }

    @CheckForNull
    private String urlForCreation(@NonNull HttpServletRequest req) {
        if (this.isCheckSameSource()) {
            if (this.isCheckOnlyLocalPath()) {
                String contextPath = req.getContextPath();
                String requestURI = req.getRequestURI();
                if (!requestURI.startsWith(contextPath)) {
                    LOGGER.log(Level.WARNING, "RequestURI {0} does not start with contextPath", requestURI);
                }
                Object localPath = requestURI.substring(contextPath.length());
                String query = req.getQueryString();
                if (query != null) {
                    localPath = (String)localPath + "?" + query;
                }
                return localPath;
            }
            String requestUrl = req.getRequestURL().toString();
            String query = req.getQueryString();
            Object url = requestUrl;
            if (query != null) {
                url = (String)url + "?" + query;
            }
            return url;
        }
        return null;
    }

    @CheckForNull
    private String urlForValidation(@NonNull HttpServletRequest req) {
        if (this.isCheckSameSource()) {
            String referer = req.getHeader(HEADER_REFERER);
            if (referer == null) {
                LOGGER.log(Level.WARNING, "No referer present in the request, perhaps it is better to check only local path");
                return null;
            }
            if (this.isCheckOnlyLocalPath()) {
                URL url;
                try {
                    url = new URL(referer);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "The referer value is not parseable as URL", e);
                    throw new RuntimeException(e);
                }
                String contextPath = req.getContextPath();
                String pathWithContext = url.getFile();
                if (!pathWithContext.startsWith(contextPath)) {
                    LOGGER.log(Level.WARNING, "Request path {0} does not start with contextPath", pathWithContext);
                    return null;
                }
                return pathWithContext.substring(contextPath.length());
            }
            return referer;
        }
        return null;
    }

    @NonNull
    private synchronized String createCrumb(@NonNull ServletRequest request, @NonNull String salt, long creationTime, @CheckForNull String sourceUrl) {
        HttpServletRequest req = (HttpServletRequest)request;
        StringBuilder builder = new StringBuilder();
        Authentication a = Jenkins.getAuthentication2();
        builder.append(a.getName());
        builder.append(';');
        if (this.isCheckClientIP()) {
            builder.append(this.getClientIP(req));
            builder.append(';');
        }
        if (sourceUrl != null) {
            builder.append(sourceUrl);
            builder.append(';');
        }
        if (this.isCheckSessionMatch()) {
            builder.append(req.getSession().getId());
            builder.append(';');
        }
        if (this.hoursValid == 0) {
            builder.append("0");
        } else {
            builder.append(creationTime);
        }
        String clearCrumb = builder.toString();
        this.md.update(clearCrumb.getBytes(StandardCharsets.UTF_8));
        byte[] crumbBytes = this.md.digest(salt.getBytes(StandardCharsets.UTF_8));
        String hashedCrumb = Util.toHexString((byte[])crumbBytes);
        return hashedCrumb;
    }

    @NonNull
    private String randomHexString(int length) {
        byte[] bytes = new byte[length / 2];
        RANDOM.nextBytes(bytes);
        return Util.toHexString((byte[])bytes);
    }

    private String getClientIP(@NonNull HttpServletRequest req) {
        String[] hopList;
        String defaultAddress = req.getRemoteAddr();
        String forwarded = req.getHeader(HEADER_X_FORWARDED_FOR);
        if (forwarded != null && (hopList = forwarded.split(",")).length >= 1) {
            return hopList[0];
        }
        return defaultAddress;
    }

    @NonNull
    private String encodeCrumb(@NonNull String clearCrumb) {
        String encodedCrumb;
        String seed;
        if (this.isXorMasking()) {
            seed = this.randomHexString(clearCrumb.length());
            encodedCrumb = this.xor(clearCrumb, seed);
        } else {
            seed = "";
            encodedCrumb = clearCrumb;
        }
        return seed + encodedCrumb;
    }

    @NonNull
    private String decodeCrumb(@NonNull String receivedCrumb) {
        String realCrumb = this.isXorMasking() ? this.unXor(receivedCrumb) : receivedCrumb;
        return realCrumb;
    }

    @NonNull
    private String unXor(@NonNull String crumbDoubleLength) {
        if (crumbDoubleLength.length() != 128) {
            return "";
        }
        String seed = crumbDoubleLength.substring(0, 64);
        String xoredCrumb = crumbDoubleLength.substring(64, 128);
        return this.xor(xoredCrumb, seed);
    }

    @NonNull
    private String xor(@NonNull String realCrumb, @NonNull String seedOfSameLength) {
        assert (realCrumb.length() == seedOfSameLength.length());
        BigInteger hexCrumb = new BigInteger(realCrumb, 16);
        BigInteger hexSeed = new BigInteger(seedOfSameLength, 16);
        BigInteger hexResult = hexCrumb.xor(hexSeed);
        String stringResult = hexResult.toString(16);
        return StrictCrumbIssuer.leftPadWithZeros(stringResult, realCrumb.length());
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"}, justification="leftPad returns null only if receiving null, which is not the case here")
    @NonNull
    private static String leftPadWithZeros(@NonNull String stringToBePadded, int length) {
        return StringUtils.leftPad((String)stringToBePadded, (int)length, (char)'0');
    }

    @Extension
    @Symbol(value={"strict"})
    public static final class DescriptorImpl
    extends CrumbIssuerDescriptor<StrictCrumbIssuer>
    implements ModelObject {
        private static final HexStringConfidentialKey CRUMB_SALT = new HexStringConfidentialKey(StrictCrumbIssuer.class, "strictCrumbSalt", 64);

        public DescriptorImpl() {
            super(CRUMB_SALT.get(), System.getProperty("hudson.security.csrf.requestfield", "Jenkins-Crumb"));
            this.load();
        }

        public String getDisplayName() {
            return "Strict Crumb Issuer";
        }

        public StrictCrumbIssuer newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (req == null) {
                throw new IllegalArgumentException("req must not be null");
            }
            return (StrictCrumbIssuer)((Object)req.bindJSON(StrictCrumbIssuer.class, formData));
        }
    }
}

