/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.stashNotifier;

import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.stashNotifier.HttpNotifier;
import org.jenkinsci.plugins.stashNotifier.NotificationContext;
import org.jenkinsci.plugins.stashNotifier.NotificationResult;
import org.jenkinsci.plugins.stashNotifier.NotificationSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultApacheHttpNotifier
implements HttpNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultApacheHttpNotifier.class);

    DefaultApacheHttpNotifier() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public NotificationResult send(@NonNull URI uri, @NonNull JSONObject payload, @NonNull NotificationSettings settings, @NonNull NotificationContext context) {
        PrintStream logger = context.getLogger();
        try (CloseableHttpClient client = this.getHttpClient(logger, uri, settings.isIgnoreUnverifiedSSL());){
            HttpPost req = this.createRequest(uri, payload, settings.getCredentials(), context);
            CloseableHttpResponse res = client.execute((HttpUriRequest)req);
            if (res.getStatusLine().getStatusCode() != 204) {
                NotificationResult notificationResult2 = NotificationResult.newFailure(EntityUtils.toString((HttpEntity)res.getEntity()));
                return notificationResult2;
            }
            NotificationResult notificationResult = NotificationResult.newSuccess();
            return notificationResult;
        }
        catch (Exception e) {
            LOGGER.warn("{} failed to send {} to Bitbucket Server at {}", new Object[]{context.getRunId(), payload, uri, e});
            logger.println("Failed to notify Bitbucket Server");
            return NotificationResult.newFailure(e.getMessage());
        }
    }

    HttpPost createRequest(URI uri, JSONObject payload, com.cloudbees.plugins.credentials.Credentials credentials, @NonNull NotificationContext context) throws AuthenticationException {
        HttpPost req = new HttpPost(uri.toString());
        if (credentials != null) {
            if (credentials instanceof UsernamePasswordCredentials) {
                LOGGER.debug("createRequest - UsernamePasswordCredentials");
                req.addHeader(new BasicScheme().authenticate((Credentials)new org.apache.http.auth.UsernamePasswordCredentials(((UsernamePasswordCredentials)credentials).getUsername(), ((UsernamePasswordCredentials)credentials).getPassword().getPlainText()), (HttpRequest)req, null));
            } else if (credentials instanceof StringCredentials) {
                LOGGER.debug("createRequest - StringCredentials/secret text");
                req.addHeader("Authorization", "Bearer " + ((StringCredentials)credentials).getSecret().getPlainText());
            } else {
                throw new AuthenticationException("Unsupported credials");
            }
        }
        req.addHeader("Content-Type", "application/json");
        req.setEntity((HttpEntity)new StringEntity(payload.toString(), "UTF-8"));
        return req;
    }

    CloseableHttpClient getHttpClient(PrintStream logger, URI stashServer, boolean ignoreUnverifiedSSL) throws Exception {
        int timeoutInMilliseconds = 60000;
        RequestConfig.Builder requestBuilder = RequestConfig.custom().setSocketTimeout(60000).setConnectTimeout(60000).setConnectionRequestTimeout(60000).setCookieSpec("standard");
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setDefaultRequestConfig(requestBuilder.build());
        URL url = stashServer.toURL();
        if (url.getProtocol().equals("https") && ignoreUnverifiedSSL) {
            try {
                SSLContext sslContext = this.buildSslContext(ignoreUnverifiedSSL, null);
                SSLConnectionSocketFactory sslConnSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnSocketFactory);
                Registry registry = RegistryBuilder.create().register("https", (Object)sslConnSocketFactory).register("http", (Object)PlainConnectionSocketFactory.INSTANCE).build();
                BasicHttpClientConnectionManager connectionManager = new BasicHttpClientConnectionManager((Lookup)registry);
                clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
            }
            catch (NoSuchAlgorithmException nsae) {
                logger.println("Could not establish SSL context");
                LOGGER.error("Could not establish SSL context", (Throwable)nsae);
            }
            catch (KeyManagementException | KeyStoreException e) {
                logger.println("Could not initialize SSL context");
                LOGGER.error("Could not initialize SSL context", (Throwable)e);
            }
        }
        this.configureProxy(clientBuilder, url);
        return clientBuilder.build();
    }

    SSLContext buildSslContext(boolean ignoreUnverifiedSSL, com.cloudbees.plugins.credentials.Credentials credentials) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContextBuilder contextBuilder = SSLContexts.custom();
        contextBuilder.setProtocol("TLS");
        if (credentials instanceof CertificateCredentials) {
            contextBuilder.loadKeyMaterial(((CertificateCredentials)credentials).getKeyStore(), ((CertificateCredentials)credentials).getPassword().getPlainText().toCharArray());
        }
        if (ignoreUnverifiedSSL) {
            contextBuilder.loadTrustMaterial(null, (TrustStrategy)TrustAllStrategy.INSTANCE);
        }
        return contextBuilder.build();
    }

    void configureProxy(HttpClientBuilder builder, URL url) {
        Jenkins jenkins = Jenkins.get();
        ProxyConfiguration proxyConfig = jenkins.proxy;
        if (proxyConfig == null) {
            return;
        }
        Proxy proxy = proxyConfig.createProxy(url.getHost());
        if (proxy == null || proxy.type() != Proxy.Type.HTTP) {
            return;
        }
        SocketAddress addr = proxy.address();
        if (!(addr instanceof InetSocketAddress)) {
            return;
        }
        InetSocketAddress proxyAddr = (InetSocketAddress)addr;
        HttpHost proxyHost = new HttpHost(proxyAddr.getAddress().getHostAddress(), proxyAddr.getPort());
        builder.setProxy(proxyHost);
        String proxyUser = proxyConfig.getUserName();
        if (proxyUser != null) {
            String proxyPass = Secret.toString((Secret)proxyConfig.getSecretPassword());
            BasicCredentialsProvider cred = new BasicCredentialsProvider();
            cred.setCredentials(new AuthScope(proxyHost), (Credentials)new org.apache.http.auth.UsernamePasswordCredentials(proxyUser, proxyPass));
            builder.setDefaultCredentialsProvider((CredentialsProvider)cred).setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
        }
    }
}

