/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.stashNotifier.example;

import com.cloudbees.plugins.credentials.Credentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.PrintStream;
import java.net.URI;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.stashNotifier.HttpNotifier;
import org.jenkinsci.plugins.stashNotifier.NotificationContext;
import org.jenkinsci.plugins.stashNotifier.NotificationResult;
import org.jenkinsci.plugins.stashNotifier.NotificationSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingHttpNotifier
implements HttpNotifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingHttpNotifier.class);

    LoggingHttpNotifier() {
    }

    @Override
    @NonNull
    public NotificationResult send(@NonNull URI uri, @NonNull JSONObject payload, @NonNull NotificationSettings settings, @NonNull NotificationContext context) {
        Credentials creds = settings.getCredentials();
        String runId = context.getRunId();
        PrintStream buildLog = context.getLogger();
        String target = uri == null ? "(undefined)" : uri.toASCIIString();
        buildLog.println("[stash-notifier] would have notified " + target + " with " + String.valueOf(payload));
        if (creds != null) {
            Class credsClass = creds.getClass();
            LOGGER.info("{} would have used {} to notify {} with payload {}", new Object[]{runId, credsClass.getSimpleName(), target, payload});
        } else {
            LOGGER.info("{} would have notified {} with payload {}", new Object[]{runId, target, payload});
        }
        return NotificationResult.newSuccess();
    }
}

