/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import java.util.Map;
import java.util.Set;

public class VariableReplacerUtil {
    public static String preludeWithEnvVars(String originalCommand, Map<String, String> vars) {
        if (originalCommand == null) {
            return null;
        }
        if (vars == null) {
            return originalCommand;
        }
        vars.remove("_");
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            if (!originalCommand.contains(entry.getKey())) continue;
            sb.append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"\n");
        }
        sb.append("\n");
        sb.append(originalCommand);
        return sb.toString();
    }

    public static String scrub(String command, Map<String, String> vars, Set<String> eyesOnlyVars) {
        if (command == null || vars == null || eyesOnlyVars == null) {
            return command;
        }
        vars.remove("_");
        block0: for (String sensitive : eyesOnlyVars) {
            for (Map.Entry<String, String> entry : vars.entrySet()) {
                if (!entry.getKey().equals(sensitive)) continue;
                String value = entry.getValue();
                if (!command.contains(value)) continue block0;
                if (command.contains("\"" + value + "\"")) {
                    command = command.replace("\"" + value + "\"", "**********");
                }
                command = command.replace(value, "**********");
                continue block0;
            }
        }
        return command;
    }
}

