/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.jvnet.hudson.plugins.CredentialsSSHSite;
import org.jvnet.hudson.plugins.Messages;
import org.jvnet.hudson.plugins.SSHBuildWrapper;
import org.jvnet.hudson.plugins.VariableReplacerUtil;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class SSHBuilder
extends Builder {
    private String siteName;
    private String command;
    private boolean execEachLine;
    private boolean hideCommand;

    @Deprecated
    public SSHBuilder(String siteName, String command) {
        this.siteName = siteName;
        this.command = command;
    }

    @DataBoundConstructor
    public SSHBuilder(String siteName, String command, boolean execEachLine) {
        this.siteName = siteName;
        this.command = command;
        this.execEachLine = execEachLine;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean getExecEachLine() {
        return this.execEachLine;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setExecEachLine(boolean execEachLine) {
        this.execEachLine = execEachLine;
    }

    @DataBoundSetter
    public void setHideCommand(boolean hideCommand) {
        this.hideCommand = hideCommand;
    }

    public boolean isHideCommand() {
        return this.hideCommand;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        CredentialsSSHSite site = this.getSite();
        if (site == null) {
            listener.getLogger().println("[SSH] No SSH site found - this is likely a configuration problem!");
            build.setResult(Result.UNSTABLE);
            return true;
        }
        site.setResolvedHostname(build.getEnvironment((TaskListener)listener).expand(site.getHostname()));
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.putAll((Map<String, String>)build.getEnvironment((TaskListener)listener));
        vars.putAll(build.getBuildVariables());
        String runtime_cmd = VariableReplacerUtil.preludeWithEnvVars(this.command, vars);
        String scrubbed_cmd = VariableReplacerUtil.scrub(runtime_cmd, vars, build.getSensitiveBuildVariables());
        if (runtime_cmd != null && runtime_cmd.trim().length() > 0) {
            if (!this.hideCommand) {
                if (this.execEachLine) {
                    listener.getLogger().printf("[SSH] commands:%n%s%n", scrubbed_cmd);
                } else {
                    listener.getLogger().printf("[SSH] script:%n%s%n", scrubbed_cmd);
                }
            }
            listener.getLogger().printf("%n[SSH] executing...%n", new Object[0]);
            return site.executeCommand(listener.getLogger(), runtime_cmd, this.execEachLine) == 0;
        }
        return true;
    }

    public CredentialsSSHSite getSite() {
        CredentialsSSHSite[] sites;
        for (CredentialsSSHSite site : sites = SSHBuildWrapper.DESCRIPTOR.getSites()) {
            if (!site.getSitename().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SSH_DisplayName();
        }

        public Builder newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (Builder)req.bindJSON(this.clazz, formData);
        }

        public ListBoxModel doFillSiteNameItems() {
            ListBoxModel m = new ListBoxModel();
            for (CredentialsSSHSite site : SSHBuildWrapper.DESCRIPTOR.getSites()) {
                m.add(site.getSitename());
            }
            return m;
        }

        public FormValidation doCheckSiteName(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"SSH Site not specified");
            }
            return FormValidation.ok();
        }
    }
}

