/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.HostnamePortSpecification;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.StreamTaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.jsch.JSchConnector;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CredentialsSSHSite {
    String hostname;
    String username;
    int port;
    String credentialId;
    int serverAliveInterval = 0;
    int timeout = 0;
    Boolean pty = Boolean.FALSE;
    transient String resolvedHostname = null;
    public static final Logger LOGGER = Logger.getLogger(CredentialsSSHSite.class.getName());
    public static final List<DomainRequirement> NO_REQUIREMENTS = Collections.emptyList();

    private CredentialsSSHSite() {
    }

    @DataBoundConstructor
    public CredentialsSSHSite(String hostname, String port, String credentialId, String serverAliveInterval, String timeout) {
        StandardUsernameCredentials credentials = this.lookupCredentialsById(credentialId);
        if (credentials != null) {
            this.username = credentials.getUsername();
        }
        this.hostname = hostname;
        try {
            this.port = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.port = 22;
        }
        this.credentialId = credentialId;
        this.setServerAliveInterval(serverAliveInterval);
        this.setTimeout(timeout);
    }

    private void closeSession(Session session, ChannelExec channel) {
        if (channel != null) {
            channel.disconnect();
        }
        if (session != null) {
            session.disconnect();
        }
    }

    private ChannelExec createChannel(PrintStream logger, Session session) throws JSchException {
        ChannelExec channel = (ChannelExec)session.openChannel("exec");
        channel.setOutputStream((OutputStream)logger, true);
        channel.setExtOutputStream((OutputStream)logger, true);
        channel.setInputStream(null);
        if (this.pty == null) {
            this.pty = Boolean.FALSE;
        }
        channel.setPty(this.pty.booleanValue());
        return channel;
    }

    private Session createSession(PrintStream logger) throws JSchException, IOException, InterruptedException {
        StandardUsernameCredentials user = this.lookupCredentialsById(this.credentialId);
        if (user == null) {
            String message = "Credentials with id '" + this.credentialId + "', no longer exist!";
            logger.println(message);
            throw new InterruptedException(message);
        }
        JSchConnector connector = new JSchConnector(user.getUsername(), this.getResolvedHostname(), this.port);
        SSHAuthenticator authenticator = SSHAuthenticator.newInstance((Object)connector, (StandardUsernameCredentials)user);
        authenticator.authenticate((TaskListener)new StreamTaskListener((OutputStream)logger, Charset.defaultCharset()));
        Session session = connector.getSession();
        session.setServerAliveInterval(this.serverAliveInterval);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect(this.timeout);
        return session;
    }

    public static CredentialsSSHSite migrateToCredentials(CredentialsSSHSite site) throws InterruptedException, IOException, Descriptor.FormException {
        String credentialId;
        if (!(site instanceof LegacySSHSite)) {
            return site;
        }
        LegacySSHSite legacy = (LegacySSHSite)site;
        List credentialsForDomain = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{new HostnamePortRequirement(site.hostname, site.port)});
        StandardUsernameCredentials existingCredentials = (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)credentialsForDomain, (CredentialsMatcher)CredentialsMatchers.withUsername((String)legacy.username));
        if (existingCredentials == null) {
            UsernamePasswordCredentialsImpl credentialsToCreate;
            String createdCredentialId = UUID.randomUUID().toString();
            if (!Strings.isNullOrEmpty((String)legacy.keyfile)) {
                credentialsToCreate = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, createdCredentialId, legacy.username, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.FileOnMasterPrivateKeySource(legacy.keyfile), legacy.password, "migrated from previous ssh-plugin version");
            } else if (!Strings.isNullOrEmpty((String)legacy.password)) {
                credentialsToCreate = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, createdCredentialId, "migrated from previous ssh-plugin version", legacy.username, legacy.password);
            } else {
                throw new InterruptedException("Did not find password nor keyfile while migrating from non-credentials SSH configuration!");
            }
            SystemCredentialsProvider credentialsProvider = SystemCredentialsProvider.getInstance();
            Map credentialsMap = credentialsProvider.getDomainCredentialsMap();
            HostnamePortSpecification hostnameSpec = new HostnamePortSpecification(site.hostname + ":" + site.port, null);
            Domain sshDomain = new Domain("ssh-plugin-" + site.hostname, "migrated ssh-plugin credentials-" + site.hostname, (List)Lists.newArrayList((Object[])new DomainSpecification[]{hostnameSpec}));
            List domainCreds = (List)credentialsMap.get(sshDomain);
            if (domainCreds == null) {
                domainCreds = Lists.newArrayList();
                credentialsMap.put(sshDomain, domainCreds);
            }
            domainCreds.add(credentialsToCreate);
            credentialsProvider.setDomainCredentialsMap(credentialsMap);
            credentialsProvider.save();
            credentialId = createdCredentialId;
        } else {
            credentialId = existingCredentials.getId();
        }
        return new CredentialsSSHSite(legacy.hostname, String.valueOf(legacy.port), credentialId, String.valueOf(legacy.serverAliveInterval), String.valueOf(legacy.timeout));
    }

    @Deprecated
    public int executeCommand(PrintStream logger, String command) throws InterruptedException {
        return this.executeCommand(logger, command, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(PrintStream logger, String command, boolean execEachLine) throws InterruptedException {
        Session session = null;
        int status = -1;
        try {
            session = this.createSession(logger);
            if (execEachLine) {
                StringTokenizer commands = new StringTokenizer(command, "\n\r\f");
                while (commands.hasMoreTokens()) {
                    int i = this.doExecCommand(session, logger, commands.nextToken().trim());
                    if (i != 0) {
                        status = i;
                        break;
                    }
                    if (commands.hasMoreTokens()) continue;
                    status = i;
                }
            } else {
                status = this.doExecCommand(session, logger, command);
            }
            logger.printf("%n[SSH] completed", new Object[0]);
            logger.printf("%n[SSH] exit-status: " + status + "%n%n", new Object[0]);
        }
        catch (JSchException e) {
            logger.println("[SSH] Exception:" + e.getMessage());
            e.printStackTrace(logger);
        }
        catch (IOException e) {
            logger.println("[SSH] Exception:" + e.getMessage());
            e.printStackTrace(logger);
        }
        finally {
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
        return status;
    }

    private int doExecCommand(Session session, PrintStream logger, String command) throws InterruptedException, IOException, JSchException {
        ChannelExec channel = null;
        int status = -1;
        try {
            channel = this.createChannel(logger, session);
            channel.setCommand(command);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] tmp = new byte[1024];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                    logger.write(tmp, 0, i);
                    continue;
                }
                if (channel.isClosed()) {
                    status = channel.getExitStatus();
                    break;
                }
                logger.flush();
                Thread.sleep(1000L);
            }
        }
        catch (JSchException e) {
            throw e;
        }
        finally {
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
        }
        return status;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getIntegerPort() {
        return this.port;
    }

    public String getPort() {
        return "" + this.port;
    }

    public Boolean getPty() {
        return this.pty;
    }

    public String getServerAliveInterval() {
        return "" + this.serverAliveInterval;
    }

    public String getSitename() {
        return this.username + "@" + this.hostname + ":" + this.port;
    }

    public String getTimeout() {
        return "" + this.timeout;
    }

    private StandardUsernameCredentials lookupCredentialsById(String credentialId) {
        List all = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)null, (Authentication)ACL.SYSTEM, NO_REQUIREMENTS);
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)all, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(String port) {
        try {
            this.port = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            this.port = 22;
        }
    }

    @DataBoundSetter
    public void setPty(Boolean pty) {
        this.pty = pty;
    }

    public void setResolvedHostname(String hostname) {
        this.resolvedHostname = hostname;
    }

    public void setServerAliveInterval(String serverAliveInterval) {
        try {
            this.serverAliveInterval = Integer.parseInt(serverAliveInterval);
        }
        catch (NumberFormatException e) {
            this.serverAliveInterval = 0;
        }
    }

    public void setTimeout(String timeout) {
        try {
            this.timeout = Integer.parseInt(timeout);
        }
        catch (NumberFormatException e) {
            this.timeout = 0;
        }
    }

    private String getResolvedHostname() {
        return this.resolvedHostname == null ? this.hostname : this.resolvedHostname;
    }

    public void testConnection(PrintStream logger) throws JSchException, IOException, InterruptedException {
        Session session = this.createSession(logger);
        this.closeSession(session, null);
    }

    public String toString() {
        return "SSHSite [username=" + this.username + ", hostname=" + this.hostname + ",port=" + this.port + ", credentialId=" + this.credentialId + ", pty=" + this.pty + "]";
    }

    public static class LegacySSHSite
    extends CredentialsSSHSite {
        transient String password;
        transient String keyfile;
    }
}

