/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.util;

import com.google.common.annotations.VisibleForTesting;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.UUID;
import jenkins.security.MasterToSlaveCallable;
import lombok.Generated;
import org.apache.log4j.MDC;
import org.jenkinsci.plugins.sshsteps.SSHService;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;

public abstract class SSHMasterToSlaveCallable
extends MasterToSlaveCallable<Object, IOException> {
    private final BasicSSHStep step;
    private final TaskListener listener;
    private SSHService service;

    public SSHMasterToSlaveCallable(BasicSSHStep step, TaskListener listener) {
        this.step = step;
        this.listener = listener;
    }

    public Object call() {
        MDC.put((String)"execution.id", (String)UUID.randomUUID().toString());
        this.service = this.createService();
        return this.execute();
    }

    @VisibleForTesting
    public SSHService createService() {
        return SSHService.create(this.step.getRemote(), this.step.isFailOnError(), this.step.isDryRun(), this.listener.getLogger());
    }

    protected abstract Object execute();

    @Generated
    public BasicSSHStep getStep() {
        return this.step;
    }

    @Generated
    public SSHService getService() {
        return this.service;
    }
}

