/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;
import org.jenkinsci.plugins.sshsteps.util.SSHMasterToSlaveCallable;
import org.jenkinsci.plugins.sshsteps.util.SSHStepDescriptorImpl;
import org.jenkinsci.plugins.sshsteps.util.SSHStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class PutStep
extends BasicSSHStep {
    private static final long serialVersionUID = 9183111587222550149L;
    private final String from;
    private final String into;
    @DataBoundSetter
    private String filterBy = "name";
    @DataBoundSetter
    private String filterRegex;

    @DataBoundConstructor
    public PutStep(String from, String into) {
        this.from = from;
        this.into = into;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getInto() {
        return this.into;
    }

    @Generated
    public String getFilterBy() {
        return this.filterBy;
    }

    @Generated
    public String getFilterRegex() {
        return this.filterRegex;
    }

    @Generated
    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    @Generated
    public void setFilterRegex(String filterRegex) {
        this.filterRegex = filterRegex;
    }

    public static class Execution
    extends SSHStepExecution {
        private static final long serialVersionUID = -4497192469254138827L;

        protected Execution(PutStep step, StepContext context) throws IOException, InterruptedException {
            super(step, context);
        }

        protected Object run() throws Exception {
            PutStep step = (PutStep)this.getStep();
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            if (Util.fixEmpty((String)step.getFrom()) == null) {
                throw new IllegalArgumentException("from is null or empty");
            }
            FilePath fromPath = ws.child(step.getFrom());
            if (!fromPath.exists()) {
                throw new IllegalArgumentException(fromPath.getRemote() + " does not exist.");
            }
            if (Util.fixEmpty((String)step.getInto()) == null) {
                throw new IllegalArgumentException("into is null or empty");
            }
            return this.getChannel().call((Callable)new PutCallable(step, this.getListener(), fromPath.getRemote()));
        }

        private static class PutCallable
        extends SSHMasterToSlaveCallable {
            private final String from;

            public PutCallable(PutStep step, TaskListener listener, String from) {
                super(step, listener);
                this.from = from;
            }

            @Override
            public Object execute() {
                PutStep step = (PutStep)this.getStep();
                return this.getService().put(this.from, step.getInto(), step.getFilterBy(), step.getFilterRegex());
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SSHStepDescriptorImpl {
        public String getFunctionName() {
            return "sshPut";
        }

        @NonNull
        public String getDisplayName() {
            return this.getPrefix() + this.getFunctionName() + " - Put a file or directory on remote node.";
        }
    }
}

