/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;
import org.jenkinsci.plugins.sshsteps.util.SSHMasterToSlaveCallable;
import org.jenkinsci.plugins.sshsteps.util.SSHStepDescriptorImpl;
import org.jenkinsci.plugins.sshsteps.util.SSHStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class RemoveStep
extends BasicSSHStep {
    private static final long serialVersionUID = -177489327125117255L;
    private final String path;

    @DataBoundConstructor
    public RemoveStep(String path) {
        this.path = path;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    public static class Execution
    extends SSHStepExecution {
        private static final long serialVersionUID = 862708152481251266L;

        protected Execution(RemoveStep step, StepContext context) throws IOException, InterruptedException {
            super(step, context);
        }

        protected Object run() throws Exception {
            RemoveStep step = (RemoveStep)this.getStep();
            if (Util.fixEmpty((String)step.getPath()) == null) {
                throw new IllegalArgumentException("path is null or empty");
            }
            return this.getChannel().call((Callable)new RemoveCallable(step, this.getListener()));
        }

        private static class RemoveCallable
        extends SSHMasterToSlaveCallable {
            public RemoveCallable(RemoveStep step, TaskListener listener) {
                super(step, listener);
            }

            @Override
            public Object execute() {
                return this.getService().remove(((RemoveStep)this.getStep()).getPath());
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SSHStepDescriptorImpl {
        public String getFunctionName() {
            return "sshRemove";
        }

        @NonNull
        public String getDisplayName() {
            return this.getPrefix() + this.getFunctionName() + " - Remove a file or directory from remote node.";
        }
    }
}

