/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.sshsteps.steps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.sshsteps.steps.BasicSSHStep;
import org.jenkinsci.plugins.sshsteps.util.SSHMasterToSlaveCallable;
import org.jenkinsci.plugins.sshsteps.util.SSHStepDescriptorImpl;
import org.jenkinsci.plugins.sshsteps.util.SSHStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CommandStep
extends BasicSSHStep {
    private static final long serialVersionUID = 7492916747486604582L;
    private final String command;
    @DataBoundSetter
    private boolean sudo = false;

    @DataBoundConstructor
    public CommandStep(String command) {
        this.command = command;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public boolean isSudo() {
        return this.sudo;
    }

    public static class Execution
    extends SSHStepExecution {
        private static final long serialVersionUID = -5293952534324828128L;

        protected Execution(CommandStep step, StepContext context) throws IOException, InterruptedException {
            super(step, context);
        }

        protected Object run() throws Exception {
            CommandStep step = (CommandStep)this.getStep();
            if (Util.fixEmpty((String)step.getCommand()) == null) {
                throw new IllegalArgumentException("command is null or empty");
            }
            return this.getChannel().call((Callable)new CommandCallable(step, this.getListener()));
        }

        private static class CommandCallable
        extends SSHMasterToSlaveCallable {
            public CommandCallable(CommandStep step, TaskListener listener) {
                super(step, listener);
            }

            @Override
            public Object execute() {
                CommandStep step = (CommandStep)this.getStep();
                return this.getService().executeCommand(step.getCommand(), step.isSudo());
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SSHStepDescriptorImpl {
        public String getFunctionName() {
            return "sshCommand";
        }

        @NonNull
        public String getDisplayName() {
            return this.getPrefix() + this.getFunctionName() + " - Execute command on remote node.";
        }
    }
}

