/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.trilead.ssh2.signature.DSASHA1Verify;
import com.trilead.ssh2.signature.RSASHA1Verify;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.KeyParseException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Deprecated
@Restricted(value={NoExternalUse.class})
final class TrileadVersionSupportManager {
    private static final Logger LOGGER = Logger.getLogger(TrileadVersionSupportManager.class.getName());

    TrileadVersionSupportManager() {
    }

    static TrileadVersionSupport getTrileadSupport() {
        try {
            if (TrileadVersionSupportManager.isAfterTrilead8()) {
                return TrileadVersionSupportManager.createVersion9Instance();
            }
        }
        catch (Exception | LinkageError e) {
            LOGGER.log(Level.WARNING, "Could not create Trilead support class. Using legacy Trilead features", e);
        }
        return new LegacyTrileadVersionSupport();
    }

    private static boolean isAfterTrilead8() {
        try {
            Class.forName("com.trilead.ssh2.signature.KeyAlgorithmManager");
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        return true;
    }

    private static TrileadVersionSupport createVersion9Instance() throws ReflectiveOperationException {
        return (TrileadVersionSupport)TrileadVersionSupportManager.class.getClassLoader().loadClass("hudson.plugins.sshslaves.verifiers.JenkinsTrilead9VersionSupport").newInstance();
    }

    public static abstract class TrileadVersionSupport {
        @Restricted(value={NoExternalUse.class})
        TrileadVersionSupport() {
        }

        public abstract String[] getSupportedAlgorithms();

        public abstract HostKey parseKey(String var1, byte[] var2) throws KeyParseException;
    }

    private static class LegacyTrileadVersionSupport
    extends TrileadVersionSupport {
        private LegacyTrileadVersionSupport() {
        }

        @Override
        public String[] getSupportedAlgorithms() {
            return new String[]{"ssh-rsa", "ssh-dss"};
        }

        @Override
        public HostKey parseKey(String algorithm, byte[] keyValue) throws KeyParseException {
            block4: {
                try {
                    if ("ssh-rsa".equals(algorithm)) {
                        RSASHA1Verify.decodeSSHRSAPublicKey((byte[])keyValue);
                        break block4;
                    }
                    if ("ssh-dss".equals(algorithm)) {
                        DSASHA1Verify.decodeSSHDSAPublicKey((byte[])keyValue);
                        break block4;
                    }
                    throw new KeyParseException("Key algorithm should be one of ssh-rsa or ssh-dss");
                }
                catch (IOException | StringIndexOutOfBoundsException ex) {
                    throw new KeyParseException(Messages.ManualKeyProvidedHostKeyVerifier_KeyValueDoesNotParse(algorithm), ex);
                }
            }
            return new HostKey(algorithm, keyValue);
        }
    }
}

