/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.HostKeyHelper;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.TrustHostKeyAction;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

@Deprecated
public class ManuallyTrustedKeyVerificationStrategy
extends SshHostKeyVerificationStrategy {
    private static final Logger LOGGER = Logger.getLogger(ManuallyTrustedKeyVerificationStrategy.class.getName());
    private final boolean requireInitialManualTrust;

    @DataBoundConstructor
    public ManuallyTrustedKeyVerificationStrategy(boolean requireInitialManualTrust) {
        this.requireInitialManualTrust = requireInitialManualTrust;
    }

    public boolean isRequireInitialManualTrust() {
        return this.requireInitialManualTrust;
    }

    @Override
    public boolean verify(SlaveComputer computer, HostKey hostKey, TaskListener listener) throws IOException {
        HostKeyHelper hostManager = HostKeyHelper.getInstance();
        HostKey existingHostKey = hostManager.getHostKey((Computer)computer);
        if (null == existingHostKey) {
            if (this.isRequireInitialManualTrust()) {
                listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyNotTrusted(SSHLauncher.getTimestamp()));
                if (!this.hasExistingTrustAction(computer, hostKey)) {
                    computer.addAction((Action)new TrustHostKeyAction((Computer)computer, hostKey));
                }
                return false;
            }
            listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyAutoTrusted(SSHLauncher.getTimestamp(), hostKey.getFingerprint()));
            HostKeyHelper.getInstance().saveHostKey((Computer)computer, hostKey);
            return true;
        }
        if (!existingHostKey.equals(hostKey)) {
            listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyNotTrusted(SSHLauncher.getTimestamp()));
            if (!this.hasExistingTrustAction(computer, hostKey)) {
                computer.addAction((Action)new TrustHostKeyAction((Computer)computer, hostKey));
            }
            return false;
        }
        listener.getLogger().println(Messages.ManualTrustingHostKeyVerifier_KeyTrusted(SSHLauncher.getTimestamp()));
        return true;
    }

    @Override
    public String[] getPreferredKeyAlgorithms(SlaveComputer computer) throws IOException {
        String[] algorithms = super.getPreferredKeyAlgorithms(computer);
        HostKey hostKey = HostKeyHelper.getInstance().getHostKey((Computer)computer);
        if (null != hostKey) {
            ArrayList<String> sortedAlgorithms = new ArrayList<String>(Arrays.asList(algorithms));
            sortedAlgorithms.remove(hostKey.getAlgorithm());
            sortedAlgorithms.add(0, hostKey.getAlgorithm());
            algorithms = sortedAlgorithms.toArray(new String[0]);
        }
        return algorithms;
    }

    private boolean hasExistingTrustAction(SlaveComputer computer, HostKey hostKey) {
        for (TrustHostKeyAction action : computer.getActions(TrustHostKeyAction.class)) {
            if (action.isComplete() || !action.getHostKey().equals(hostKey)) continue;
            return true;
        }
        return false;
    }

    @Extension
    public static class ManuallyTrustedKeyVerificationStrategyDescriptor
    extends SshHostKeyVerificationStrategy.SshHostKeyVerificationStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ManualTrustingHostKeyVerifier_DescriptorDisplayName();
        }
    }
}

