/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Slave;
import hudson.plugins.sshslaves.mina.Messages;
import hudson.plugins.sshslaves.mina.MinaServerKeyVerificationStrategy;
import hudson.slaves.EphemeralNode;
import hudson.slaves.SlaveComputer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.Nodes;
import org.apache.commons.io.FileUtils;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class TrustOnFirstUseVerificationStrategy
extends MinaServerKeyVerificationStrategy {
    private static final Logger LOGGER = Logger.getLogger(TrustOnFirstUseVerificationStrategy.class.getName());
    private final boolean manualVerification;

    @DataBoundConstructor
    public TrustOnFirstUseVerificationStrategy(boolean manualVerification) {
        this.manualVerification = manualVerification;
    }

    public boolean isManualVerification() {
        return this.manualVerification;
    }

    @Override
    @NonNull
    public ServerKeyVerifier createVerifier(SlaveComputer computer, String host) {
        AuthorizedKeyEntry storedEntry;
        try {
            storedEntry = this.loadStoredKey(computer);
        }
        catch (IOException e) {
            storedEntry = null;
        }
        if (storedEntry != null) {
            try {
                PublicKey expected = storedEntry.resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
                return (clientSession, remoteAddress, serverKey) -> {
                    boolean result = KeyUtils.compareKeys((PublicKey)expected, (PublicKey)serverKey);
                    LOGGER.log(Level.FINE, () -> "Comparing expected: " + String.valueOf(expected) + ", serverKey: " + String.valueOf(serverKey) + ", result: " + result);
                    return result;
                };
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Error resolving stored key for verification", e);
            }
        }
        return (clientSession, remoteAddress, serverKey) -> {
            PublicKeyEntryDecoder decoder = KeyUtils.getPublicKeyEntryDecoder((Key)serverKey);
            try (ByteArrayOutputStream s = new ByteArrayOutputStream(127);){
                AuthorizedKeyEntry newEntry = new AuthorizedKeyEntry();
                newEntry.setKeyType(decoder.encodePublicKey((OutputStream)s, serverKey));
                newEntry.setKeyData(s.toByteArray());
                if (this.manualVerification) {
                    LOGGER.log(Level.FINE, () -> "Manual verification required, rejecting first-time key");
                    boolean bl = false;
                    return bl;
                }
                this.storeKey(computer, newEntry);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Error saving server key", e);
                return false;
            }
        };
    }

    private AuthorizedKeyEntry loadStoredKey(SlaveComputer computer) throws IOException {
        File nodesDir = TrustOnFirstUseVerificationStrategy.getNodesDir();
        Slave node = computer.getNode();
        if (node == null || node instanceof EphemeralNode || nodesDir == null) {
            return null;
        }
        File authorizedKeyFile = new File(new File(nodesDir, node.getNodeName()), "authorized_key");
        if (authorizedKeyFile.isFile()) {
            return AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)FileUtils.readFileToString((File)authorizedKeyFile, (String)"UTF-8"));
        }
        return null;
    }

    private void storeKey(SlaveComputer computer, AuthorizedKeyEntry entry) {
        File nodesDir = TrustOnFirstUseVerificationStrategy.getNodesDir();
        Slave node = computer.getNode();
        if (node == null || node instanceof EphemeralNode || nodesDir == null) {
            return;
        }
        File authorizedKeyFile = new File(new File(nodesDir, node.getNodeName()), "authorized_key");
        if (entry == null) {
            FileUtils.deleteQuietly((File)authorizedKeyFile);
        } else {
            StringBuilder buf = new StringBuilder();
            try {
                entry.appendPublicKey(null, (Appendable)buf, PublicKeyEntryResolver.IGNORING);
                FileUtils.write((File)authorizedKeyFile, (CharSequence)buf, (String)"UTF-8");
            }
            catch (IOException | GeneralSecurityException e) {
                FileUtils.deleteQuietly((File)authorizedKeyFile);
            }
        }
    }

    private static File getNodesDir() {
        Jenkins jenkins = Jenkins.get();
        try {
            Method getNodesDir = Nodes.class.getDeclaredMethod("getNodesDir", new Class[0]);
            getNodesDir.setAccessible(true);
            Method getNodesObject = Jenkins.class.getDeclaredMethod("getNodesObject", new Class[0]);
            getNodesObject.setAccessible(true);
            Object nodes = getNodesObject.invoke((Object)jenkins, new Object[0]);
            return (File)getNodesDir.invoke(nodes, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            File nodesDir = new File(jenkins.getRootDir(), "nodes");
            if (!nodesDir.isDirectory() && !nodesDir.mkdirs()) {
                return null;
            }
            return nodesDir;
        }
    }

    @Extension
    @Symbol(value={"minaTrustFirstUse"})
    public static class DescriptorImpl
    extends MinaServerKeyVerificationStrategy.MinaServerKeyVerificationStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.TrustOnFirstUseVerificationStrategy_DisplayName();
        }
    }
}

