/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.keyverifier.DelegatingServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.global.KeepAliveHandler;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionListener;

final class MinaSshClient {
    private static final Logger LOGGER = Logger.getLogger(MinaSshClient.class.getName());
    static final AttributeRepository.AttributeKey<List<String>> PREFERRED_ALGORITHMS_KEY = new AttributeRepository.AttributeKey();
    private static SshClient client;

    static synchronized SshClient getClient() {
        if (client != null) {
            return client;
        }
        client = ClientBuilder.builder().serverKeyVerifier((ServerKeyVerifier)new DelegatingServerKeyVerifier()).build(true);
        client.addSessionListener(new SessionListener(){

            public void sessionNegotiationOptionsCreated(Session session, Map<KexProposalOption, String> proposal) {
                String currentAlgorithms;
                List<String> preferredAlgorithms = this.getPreferredAlgorithms(session);
                if (!preferredAlgorithms.isEmpty() && (currentAlgorithms = proposal.get(KexProposalOption.SERVERKEYS)) != null && !currentAlgorithms.isEmpty()) {
                    String reordered = MinaSshClient.reorderAlgorithms(currentAlgorithms, preferredAlgorithms);
                    proposal.put(KexProposalOption.SERVERKEYS, reordered);
                    LOGGER.log(Level.FINE, () -> "Reordered host key algorithms for session: " + reordered);
                }
            }

            private List<String> getPreferredAlgorithms(Session session) {
                ClientSession clientSession;
                AttributeRepository context;
                List result = (List)session.getAttribute(PREFERRED_ALGORITHMS_KEY);
                if (result != null) {
                    return result;
                }
                if (session instanceof ClientSession && (context = (clientSession = (ClientSession)session).getConnectionContext()) != null && (result = (List)context.getAttribute(PREFERRED_ALGORITHMS_KEY)) != null) {
                    return result;
                }
                return Collections.emptyList();
            }
        });
        ArrayList<KeepAliveHandler> requestHandlers = client.getGlobalRequestHandlers();
        requestHandlers = requestHandlers == null ? new ArrayList<KeepAliveHandler>() : new ArrayList(requestHandlers);
        boolean found = false;
        for (RequestHandler requestHandler : requestHandlers) {
            if (!(requestHandler instanceof KeepAliveHandler)) continue;
            found = true;
            break;
        }
        if (!found) {
            requestHandlers.add(new KeepAliveHandler());
            client.setGlobalRequestHandlers(requestHandlers);
        }
        client.start();
        LOGGER.fine("Mina SshClient started");
        return client;
    }

    static String reorderAlgorithms(String currentAlgorithms, List<String> preferredAlgorithms) {
        ArrayList<String> algorithms = new ArrayList<String>(Arrays.asList(currentAlgorithms.split(",")));
        ArrayList<String> preferred = new ArrayList<String>();
        ArrayList<String> others = new ArrayList<String>();
        for (String algo : algorithms) {
            String trimmed = algo.trim();
            boolean isPreferred = preferredAlgorithms.stream().anyMatch(pref -> trimmed.toLowerCase().contains(pref.toLowerCase().replace("ssh-", "")));
            if (isPreferred) {
                preferred.add(trimmed);
                continue;
            }
            others.add(trimmed);
        }
        preferred.addAll(others);
        LOGGER.log(Level.FINE, () -> "Preferred host key algorithms: " + String.valueOf(preferred) + ", others: " + String.valueOf(others) + ", current: " + currentAlgorithms);
        return String.join((CharSequence)",", preferred);
    }

    static synchronized void stop() {
        if (client != null) {
            try {
                client.stop();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error stopping Mina SshClient", e);
            }
            client = null;
        }
    }

    private MinaSshClient() {
    }
}

