/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.Extension;
import hudson.Functions;
import hudson.Util;
import hudson.init.Terminator;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.mina.BlindTrustVerificationStrategy;
import hudson.plugins.sshslaves.mina.LoggingServerKeyVerifier;
import hudson.plugins.sshslaves.mina.Messages;
import hudson.plugins.sshslaves.mina.MinaServerKeyVerificationStrategy;
import hudson.plugins.sshslaves.mina.MinaSshClient;
import hudson.remoting.Channel;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.io.output.CloseShieldOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.scp.client.DefaultScpClient;
import org.apache.sshd.scp.common.ScpTransferEventListener;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.common.SftpException;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class MinaSSHLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(MinaSSHLauncher.class.getName());
    public static final int DEFAULT_SSH_PORT = 22;
    public static final Integer DEFAULT_MAX_NUM_RETRIES = 10;
    public static final Integer DEFAULT_RETRY_WAIT_TIME = 15;
    public static final Integer DEFAULT_LAUNCH_TIMEOUT_SECONDS = 60;
    public static final String AGENT_JAR = "remoting.jar";
    public static final SchemeRequirement SSH_SCHEME = new SchemeRequirement("ssh");
    public static final int TIMEOUT = Integer.getInteger(MinaSSHLauncher.class.getName() + ".TIMEOUT", 60000);
    @GuardedBy(value="class")
    private static WeakReference<byte[]> agentJarBytes;
    private final String host;
    private final int port;
    private final String credentialsId;
    private String jvmOptions;
    private String javaPath;
    private String prefixStartSlaveCmd;
    private String suffixStartSlaveCmd;
    private Integer launchTimeoutSeconds;
    private Integer maxNumRetries;
    private Integer retryWaitTime;
    private Boolean tcpNoDelay;
    private String workDir;
    private MinaServerKeyVerificationStrategy serverKeyVerificationStrategy;
    private volatile transient ClientSession session;

    @DataBoundConstructor
    public MinaSSHLauncher(@NonNull String host, int port, String credentialsId) {
        this.host = host;
        this.port = port == 0 ? 22 : port;
        this.credentialsId = credentialsId;
    }

    @NonNull
    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port == 0 ? 22 : this.port;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getJvmOptions() {
        return this.jvmOptions;
    }

    @DataBoundSetter
    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = Util.fixEmpty((String)jvmOptions);
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    @DataBoundSetter
    public void setJavaPath(String javaPath) {
        this.javaPath = Util.fixEmpty((String)javaPath);
    }

    public String getPrefixStartSlaveCmd() {
        return this.prefixStartSlaveCmd;
    }

    @DataBoundSetter
    public void setPrefixStartSlaveCmd(String prefixStartSlaveCmd) {
        this.prefixStartSlaveCmd = Util.fixEmpty((String)prefixStartSlaveCmd);
    }

    public String getSuffixStartSlaveCmd() {
        return this.suffixStartSlaveCmd;
    }

    @DataBoundSetter
    public void setSuffixStartSlaveCmd(String suffixStartSlaveCmd) {
        this.suffixStartSlaveCmd = Util.fixEmpty((String)suffixStartSlaveCmd);
    }

    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds == null ? DEFAULT_LAUNCH_TIMEOUT_SECONDS : this.launchTimeoutSeconds;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer launchTimeoutSeconds) {
        this.launchTimeoutSeconds = launchTimeoutSeconds;
    }

    public Integer getMaxNumRetries() {
        return this.maxNumRetries == null ? DEFAULT_MAX_NUM_RETRIES : this.maxNumRetries;
    }

    @DataBoundSetter
    public void setMaxNumRetries(Integer maxNumRetries) {
        this.maxNumRetries = maxNumRetries;
    }

    public Integer getRetryWaitTime() {
        return this.retryWaitTime == null ? DEFAULT_RETRY_WAIT_TIME : this.retryWaitTime;
    }

    @DataBoundSetter
    public void setRetryWaitTime(Integer retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    public Boolean getTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @DataBoundSetter
    public void setTcpNoDelay(Boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    @DataBoundSetter
    public void setWorkDir(String workDir) {
        this.workDir = Util.fixEmpty((String)workDir);
    }

    public MinaServerKeyVerificationStrategy getServerKeyVerificationStrategy() {
        return this.serverKeyVerificationStrategy;
    }

    @DataBoundSetter
    public void setServerKeyVerificationStrategy(MinaServerKeyVerificationStrategy serverKeyVerificationStrategy) {
        this.serverKeyVerificationStrategy = serverKeyVerificationStrategy;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        ClientSession connectedSession;
        long startTime = System.currentTimeMillis();
        StandardUsernameCredentials credentials = this.lookupCredentials();
        if (credentials == null) {
            throw new AbortException("[SSH Mina] Cannot find specified credentials: " + this.credentialsId);
        }
        if (!SSHAuthenticator.isSupported(ClientSession.class, (Class)credentials.getClass())) {
            throw new AbortException("[SSH Mina] Incompatible credentials: " + CredentialsNameProvider.name((Credentials)credentials));
        }
        MinaServerKeyVerificationStrategy strategy = this.getServerKeyVerificationStrategyDefaulted();
        List<String> preferredAlgorithms = strategy.getPreferredKeyAlgorithms();
        this.session = connectedSession = this.openConnection(listener, computer, credentials, preferredAlgorithms);
        connectedSession.getMetadataMap().put(ServerKeyVerifier.class, new LoggingServerKeyVerifier(strategy.createVerifier(computer, this.host), listener));
        MinaSSHLauncher.println(listener, "Authenticating as " + CredentialsNameProvider.name((Credentials)credentials));
        if (!SSHAuthenticator.newInstance((Object)connectedSession, (StandardUsernameCredentials)credentials).authenticate(listener)) {
            MinaSSHLauncher.println(listener, "Authentication failed");
            connectedSession.close(true);
            return;
        }
        MinaSSHLauncher.println(listener, "Authentication successful");
        try {
            this.verifyNoHeaderJunk(connectedSession, listener);
            String workingDirectory = MinaSSHLauncher.getWorkingDirectory(computer);
            MinaSSHLauncher.println(listener, "Remote SSH server: " + connectedSession.getServerVersion());
            String java = this.resolveJava(connectedSession, listener);
            this.copyAgentJar(connectedSession, listener, workingDirectory);
            this.startAgent(computer, listener, connectedSession, workingDirectory, java);
            double elapsed = (double)(System.currentTimeMillis() - startTime) * 0.001;
            MinaSSHLauncher.println(listener, "Connection established after " + String.format("%.1f", elapsed) + " seconds");
        }
        catch (RuntimeException e) {
            connectedSession.close(true);
            throw e;
        }
        catch (Throwable e) {
            connectedSession.close(true);
            throw new IOException(e.getMessage(), e);
        }
    }

    public void afterDisconnect(SlaveComputer slaveComputer, TaskListener listener) {
        ClientSession currentSession = this.session;
        if (currentSession != null) {
            try {
                currentSession.close(true);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Error closing Mina SSH session", e);
            }
            this.session = null;
        }
        super.afterDisconnect(slaveComputer, listener);
    }

    private ClientSession openConnection(TaskListener listener, SlaveComputer computer, StandardUsernameCredentials credentials, List<String> preferredAlgorithms) throws IOException, InterruptedException {
        SshClient client = MinaSshClient.getClient();
        int effectivePort = this.getPort();
        int maxRetries = this.getMaxNumRetries();
        int retryWait = this.getRetryWaitTime();
        for (int attempt = 0; attempt <= maxRetries; ++attempt) {
            try {
                MinaSSHLauncher.println(listener, "Opening SSH connection to " + this.host + ":" + effectivePort + " as " + CredentialsNameProvider.name((Credentials)credentials));
                AttributeStore context = null;
                if (!preferredAlgorithms.isEmpty()) {
                    context = MinaSSHLauncher.createAttributeStore();
                    context.setAttribute(MinaSshClient.PREFERRED_ALGORITHMS_KEY, preferredAlgorithms);
                }
                ConnectFuture future = client.connect(credentials.getUsername(), this.host, effectivePort, (AttributeRepository)context, null);
                future.await((long)this.getLaunchTimeoutSeconds().intValue(), TimeUnit.SECONDS);
                if (!future.isConnected()) {
                    throw new IOException("SSH connection timed out");
                }
                return (ClientSession)future.getSession();
            }
            catch (IOException e) {
                if (attempt >= maxRetries) {
                    throw e;
                }
                MinaSSHLauncher.println(listener, "SSH connection failed: " + e.getMessage() + ". Retrying in " + retryWait + " seconds (" + (attempt + 1) + "/" + maxRetries + ")");
                Thread.sleep((long)retryWait * 1000L);
                continue;
            }
        }
        throw new IOException("SSH connection failed after " + maxRetries + " retries");
    }

    private void startAgent(SlaveComputer computer, final TaskListener listener, final ClientSession connectedSession, String workingDirectory, String java) throws IOException, InterruptedException {
        String prefix = StringUtils.isNotBlank((CharSequence)this.prefixStartSlaveCmd) ? this.prefixStartSlaveCmd + " " : "";
        String suffix = StringUtils.isNotBlank((CharSequence)this.suffixStartSlaveCmd) ? " " + this.suffixStartSlaveCmd : "";
        String jvmOpts = StringUtils.defaultString((String)this.jvmOptions);
        String cmd = prefix + "cd \"" + workingDirectory + "\" && \"" + java + "\" " + jvmOpts + " -jar remoting.jar" + suffix;
        final ChannelExec process = connectedSession.createExecChannel(cmd);
        MinaSSHLauncher.println(listener, "$ " + cmd);
        process.open().await();
        process.setErr((OutputStream)CloseShieldOutputStream.wrap((OutputStream)listener.getLogger()));
        computer.setChannel(process.getInvertedOut(), process.getInvertedIn(), (OutputStream)listener.getLogger(), new Channel.Listener(this){
            final /* synthetic */ MinaSSHLauncher this$0;
            {
                this.this$0 = this$0;
            }

            public void onClosed(Channel channel, IOException cause) {
                if (cause != null) {
                    Functions.printStackTrace((Throwable)cause, (PrintWriter)listener.error("[SSH Mina] Agent terminated"));
                }
                try {
                    process.close(true);
                }
                catch (Throwable t) {
                    Functions.printStackTrace((Throwable)t, (PrintWriter)listener.error("[SSH Mina] Error while closing SSH channel"));
                }
                try {
                    connectedSession.close(true);
                }
                catch (Throwable t) {
                    Functions.printStackTrace((Throwable)t, (PrintWriter)listener.error("[SSH Mina] Error while closing SSH session"));
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAgentJar(ClientSession connectedSession, final TaskListener listener, String workingDirectory) throws IOException {
        String fileName = workingDirectory.endsWith("/") ? workingDirectory + AGENT_JAR : workingDirectory + "/remoting.jar";
        byte[] slaveJar = MinaSSHLauncher.getAgentJarBytes();
        String digest = Util.getDigestOf((InputStream)new ByteArrayInputStream(slaveJar));
        MinaSSHLauncher.println(listener, "Verifying agent jar...");
        ChannelExec execChannel = null;
        try {
            String cmd = "mkdir -p \"" + workingDirectory + "\" 2>/dev/null ; md5sum \"" + fileName + "\" || md5 \"" + fileName + "\"";
            execChannel = connectedSession.createExecChannel(cmd);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            execChannel.setOut((OutputStream)baos);
            execChannel.setErr((OutputStream)baos);
            execChannel.open().await();
            execChannel.waitFor(Arrays.asList(ClientChannelEvent.EOF, ClientChannelEvent.EXIT_STATUS), (long)TIMEOUT);
            execChannel.close(false);
            execChannel = null;
            String output = baos.toString(StandardCharsets.UTF_8);
            if (output.toLowerCase().contains(digest) && digest.length() > 30) {
                MinaSSHLauncher.println(listener, "Agent jar is current (" + digest + ")");
                return;
            }
        }
        catch (IOException cmd) {
        }
        finally {
            if (execChannel != null) {
                execChannel.close(true);
            }
        }
        SftpClientFactory factory = SftpClientFactory.instance();
        try (SftpClient sftp = factory.createSftpClient(connectedSession);){
            MinaSSHLauncher.println(listener, "Copying agent jar via SFTP...");
            try {
                SftpClient.Attributes stat = sftp.stat(workingDirectory);
                if (stat.isRegularFile()) {
                    throw new IOException("Remote FS " + workingDirectory + " is a file, not a directory");
                }
            }
            catch (SshException | SftpException e) {
                MinaSSHLauncher.println(listener, "Remote directory " + workingDirectory + " does not exist, creating...");
                MinaSSHLauncher.mkdirs(sftp, workingDirectory, 448);
            }
            try {
                sftp.remove(fileName);
            }
            catch (IOException e) {
                // empty catch block
            }
            try (SftpClient.CloseableHandle handle = sftp.open(fileName, EnumSet.of(SftpClient.OpenMode.Create, SftpClient.OpenMode.Write));){
                int offset;
                int size;
                for (offset = 0; offset < slaveJar.length; offset += size) {
                    size = Math.min(32768, slaveJar.length - offset);
                    sftp.write((SftpClient.Handle)handle, (long)offset, slaveJar, offset, size);
                }
                MinaSSHLauncher.println(listener, "Copied " + offset + " bytes via SFTP");
            }
            catch (Exception e) {
                connectedSession.close(true);
                throw new IOException("Error copying agent jar into " + workingDirectory, e);
            }
        }
        catch (IOException e) {
            MinaSSHLauncher.println(listener, "SFTP failed, trying SCP...");
            DefaultScpClient client = new DefaultScpClient(connectedSession, null, new ScpTransferEventListener(){
                final /* synthetic */ MinaSSHLauncher this$0;
                {
                    this.this$0 = this$0;
                }

                public void startFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path path, long length, Set<PosixFilePermission> perms) {
                    MinaSSHLauncher.println(listener, "Sending file " + String.valueOf(path));
                }

                public void endFileEvent(Session session, ScpTransferEventListener.FileOperation op, Path path, long length, Set<PosixFilePermission> perms, Throwable thrown) {
                    MinaSSHLauncher.println(listener, "Sent file " + String.valueOf(path));
                }

                public void startFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path path, Set<PosixFilePermission> perms) {
                }

                public void endFolderEvent(Session session, ScpTransferEventListener.FileOperation op, Path path, Set<PosixFilePermission> perms, Throwable thrown) {
                }
            });
            client.upload(slaveJar, fileName, Collections.singleton(PosixFilePermission.OWNER_READ), null);
            MinaSSHLauncher.println(listener, "Copied " + slaveJar.length + " bytes via SCP");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNoHeaderJunk(ClientSession connectedSession, TaskListener listener) throws IOException, InterruptedException {
        MinaSSHLauncher.println(listener, "Checking for header junk...");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ChannelExec execChannel = connectedSession.createExecChannel("true");
        try {
            execChannel.setOut((OutputStream)baos);
            execChannel.open().await();
            execChannel.waitFor(Collections.singleton(ClientChannelEvent.EOF), (long)TIMEOUT);
        }
        finally {
            execChannel.close(false);
        }
        if (baos.toByteArray().length != 0) {
            String junk = baos.toString(StandardCharsets.UTF_8);
            MinaSSHLauncher.println(listener, "Header junk detected: " + junk);
            throw new AbortException("SSH header junk detected. Please disable banner printing and .profile/.bashrc output.");
        }
        MinaSSHLauncher.println(listener, "No header junk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resolveJava(ClientSession connectedSession, TaskListener listener) throws IOException, InterruptedException {
        MinaSSHLauncher.println(listener, "Verifying Java...");
        if (StringUtils.isNotBlank((CharSequence)this.javaPath)) {
            return this.javaPath;
        }
        List<String> candidates = Arrays.asList("java", "/usr/bin/java", "/usr/java/default/bin/java", "/usr/java/latest/bin/java", "/usr/local/bin/java", "/usr/local/java/bin/java");
        ArrayList<String> tried = new ArrayList<String>();
        for (String javaCommand : candidates) {
            MinaSSHLauncher.println(listener, "Trying " + javaCommand + "...");
            tried.add(javaCommand);
            ChannelExec execChannel = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                String cmd = "\"" + javaCommand + "\" " + StringUtils.defaultString((String)this.jvmOptions) + " -version 2>&1";
                execChannel = connectedSession.createExecChannel(cmd);
                execChannel.setOut((OutputStream)baos);
                execChannel.setErr((OutputStream)baos);
                execChannel.open().await();
                execChannel.waitFor(Collections.singletonList(ClientChannelEvent.EOF), (long)TIMEOUT);
                execChannel.close(false);
                execChannel = null;
                String output = baos.toString(StandardCharsets.UTF_8);
                this.checkJavaVersion(listener, javaCommand, output);
                String string = javaCommand;
                return string;
            }
            catch (IOException iOException) {}
            continue;
            finally {
                if (execChannel == null) continue;
                execChannel.close(true);
            }
        }
        throw new IOException("Could not find any known supported Java version in " + String.valueOf(tried));
    }

    private void checkJavaVersion(TaskListener listener, String javaCommand, String output) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (!line.contains("version")) continue;
            MinaSSHLauncher.println(listener, "Found " + javaCommand + ": " + line.trim());
            return;
        }
        throw new IOException(javaCommand + " -version did not produce recognizable output: " + output);
    }

    private MinaServerKeyVerificationStrategy getServerKeyVerificationStrategyDefaulted() {
        if (this.serverKeyVerificationStrategy == null) {
            return new BlindTrustVerificationStrategy();
        }
        return this.serverKeyVerificationStrategy;
    }

    private StandardUsernameCredentials lookupCredentials() {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernameCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, List.of(SSH_SCHEME)), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    private static String getWorkingDirectory(SlaveComputer computer) {
        Slave node = computer.getNode();
        if (node == null) {
            throw new IllegalStateException("Node is null");
        }
        String dir = node.getRemoteFS();
        while (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        return dir;
    }

    private static synchronized byte[] getAgentJarBytes() throws IOException {
        byte[] ref;
        byte[] byArray = ref = agentJarBytes == null ? null : (byte[])agentJarBytes.get();
        if (ref != null) {
            return ref;
        }
        ref = new Slave.JnlpJar(AGENT_JAR).readFully();
        agentJarBytes = new WeakReference<byte[]>(ref);
        return ref;
    }

    private static void mkdirs(SftpClient sftp, String path, int mode) throws IOException {
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        int i = ((String)path).indexOf(47);
        while (i != -1) {
            if (i != 0) {
                try {
                    sftp.stat(((String)path).substring(0, i));
                }
                catch (SftpException e) {
                    sftp.mkdir(((String)path).substring(0, i));
                    sftp.setStat(((String)path).substring(0, i), new SftpClient.Attributes().perms(mode));
                }
            }
            i = ((String)path).indexOf(47, i + 1);
        }
    }

    private static AttributeStore createAttributeStore() {
        return new AttributeStore(){
            private final ConcurrentHashMap<AttributeRepository.AttributeKey<?>, Object> attributes = new ConcurrentHashMap();

            public <T> T getAttribute(AttributeRepository.AttributeKey<T> key) {
                return (T)this.attributes.get(key);
            }

            public <T> T setAttribute(AttributeRepository.AttributeKey<T> key, T value) {
                return (T)(value != null ? this.attributes.put(key, value) : this.attributes.remove(key));
            }

            public <T> T removeAttribute(AttributeRepository.AttributeKey<T> key) {
                return (T)this.attributes.remove(key);
            }

            public int getAttributesCount() {
                return this.attributes.size();
            }

            public void clearAttributes() {
                this.attributes.clear();
            }

            public Collection<AttributeRepository.AttributeKey<?>> attributeKeys() {
                return this.attributes.keySet();
            }
        };
    }

    @Terminator
    public static void stopMinaSshClient() {
        MinaSshClient.stop();
    }

    private static void println(TaskListener listener, String message) {
        listener.getLogger().println("[SSH Mina] " + message);
    }

    @Extension
    @Symbol(value={"sshMina"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @NonNull
        public String getDisplayName() {
            return Messages.MinaSSHLauncher_DisplayName();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ModelObject context, @QueryParameter String host, @QueryParameter String port, @QueryParameter String credentialsId) {
            Jenkins aclHolder;
            Jenkins jenkins = Jenkins.getInstanceOrNull();
            Object object = aclHolder = context instanceof AccessControlled ? (AccessControlled)context : jenkins;
            if (aclHolder == null) {
                return new StandardUsernameListBoxModel();
            }
            if (aclHolder instanceof Item) {
                if (!aclHolder.hasPermission(Item.CONFIGURE)) {
                    aclHolder.checkPermission(Item.EXTENDED_READ);
                    return new StandardUsernameListBoxModel();
                }
            } else if (aclHolder instanceof Computer || aclHolder == jenkins) {
                if (!aclHolder.hasPermission(Computer.CONFIGURE)) {
                    aclHolder.checkPermission(Computer.EXTENDED_READ);
                    return new StandardUsernameListBoxModel();
                }
            } else {
                return new StandardUsernameListBoxModel();
            }
            ArrayList<Object> domainRequirements = new ArrayList<Object>();
            domainRequirements.add(SSH_SCHEME);
            if (StringUtils.isNotBlank((CharSequence)host)) {
                try {
                    int portValue = StringUtils.isBlank((CharSequence)port) ? 22 : Integer.parseInt(port);
                    domainRequirements.add(new HostnamePortRequirement(host, portValue));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (context instanceof Item) {
                return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM, (Item)context, StandardUsernameCredentials.class, domainRequirements, SSHAuthenticator.matcher(ClientSession.class));
            }
            return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM, (ItemGroup)jenkins, StandardUsernameCredentials.class, domainRequirements, SSHAuthenticator.matcher(ClientSession.class));
        }

        @POST
        public FormValidation doCheckHost(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"Host is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckPort(@QueryParameter String value) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    int port = Integer.parseInt(value);
                    if (port < 1 || port > 65535) {
                        return FormValidation.error((String)"Port must be between 1 and 65535");
                    }
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)"Invalid port number");
                }
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCredentialsId(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.error((String)"Credentials are required");
            }
            return FormValidation.ok();
        }
    }
}

