/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.sshslaves.mina.Messages;
import hudson.plugins.sshslaves.mina.MinaServerKeyVerificationStrategy;
import hudson.slaves.SlaveComputer;
import hudson.util.FormValidation;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.keyverifier.RejectAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.RequiredServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ManualKeyVerificationStrategy
extends MinaServerKeyVerificationStrategy {
    private static final Logger LOGGER = Logger.getLogger(ManualKeyVerificationStrategy.class.getName());
    private final String key;
    private transient AuthorizedKeyEntry entry;

    @DataBoundConstructor
    public ManualKeyVerificationStrategy(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    private AuthorizedKeyEntry getEntry() {
        if (this.entry == null) {
            this.entry = AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)this.key);
        }
        return this.entry;
    }

    @Override
    @NonNull
    public ServerKeyVerifier createVerifier(SlaveComputer computer, String host) {
        AuthorizedKeyEntry keyEntry = this.getEntry();
        if (keyEntry != null) {
            try {
                PublicKey publicKey = keyEntry.resolvePublicKey(null, PublicKeyEntryResolver.IGNORING);
                if (publicKey != null) {
                    return new RequiredServerKeyVerifier(publicKey);
                }
                LOGGER.log(Level.FINE, () -> "Could not resolve public key from the configured server key, all keys are rejected.");
            }
            catch (IOException | GeneralSecurityException e) {
                LOGGER.log(Level.FINE, "Error resolving the configured server key, all keys are rejected.", e);
            }
        } else {
            LOGGER.log(Level.FINE, () -> "No server key configured, all keys are rejected.");
        }
        return RejectAllServerKeyVerifier.INSTANCE;
    }

    @Override
    @NonNull
    public List<String> getPreferredKeyAlgorithms() {
        String keyType;
        AuthorizedKeyEntry keyEntry = this.getEntry();
        if (keyEntry != null && (keyType = keyEntry.getKeyType()) != null && !keyType.isEmpty()) {
            LOGGER.log(Level.FINE, () -> "Configured host key type: " + keyType);
            return Collections.singletonList(keyType);
        }
        return Collections.emptyList();
    }

    @Extension
    @Symbol(value={"minaManualKey"})
    public static class DescriptorImpl
    extends MinaServerKeyVerificationStrategy.MinaServerKeyVerificationStrategyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ManualKeyVerificationStrategy_DisplayName();
        }

        public FormValidation doCheckKey(@QueryParameter String value) {
            try {
                if (AuthorizedKeyEntry.parseAuthorizedKeyEntry((String)value) == null) {
                    return FormValidation.error((String)"No valid key recovered");
                }
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }
    }
}

