/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import hudson.model.TaskListener;
import java.net.SocketAddress;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.FIPS140;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.KeyUtils;

class LoggingServerKeyVerifier
implements ServerKeyVerifier {
    private static final Logger LOGGER = Logger.getLogger(LoggingServerKeyVerifier.class.getName());
    private final ServerKeyVerifier delegate;
    private final TaskListener listener;

    LoggingServerKeyVerifier(ServerKeyVerifier delegate, TaskListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        String kind;
        if (serverKey instanceof ECPublicKey) {
            kind = "ECDSA";
        } else if (serverKey instanceof RSAPublicKey) {
            kind = "RSA";
        } else if (serverKey instanceof DSAPublicKey) {
            kind = "DSA";
        } else {
            if (FIPS140.useCompliantAlgorithms()) {
                this.listener.getLogger().format("[SSH Mina] Error unknown server host key: %s%n", serverKey);
                return false;
            }
            if (!"net.i2p.crypto.eddsa.EdDSAPublicKey".equals(serverKey.getClass().getName())) {
                this.listener.getLogger().format("[SSH Mina] Warning unknown server host key type: %s%n", serverKey);
            }
            kind = serverKey.getAlgorithm();
        }
        LOGGER.log(Level.FINE, () -> "use kind " + kind + " for host " + String.valueOf(clientSession.getRemoteAddress()) + " publicKey: " + String.valueOf(serverKey));
        this.listener.getLogger().format("[SSH Mina] Verifying server host key...%n", new Object[0]);
        this.listener.getLogger().format("[SSH Mina] %s key fingerprint is %s%n", kind, KeyUtils.getFingerPrint((PublicKey)serverKey));
        boolean result = this.delegate.verifyServerKey(clientSession, remoteAddress, serverKey);
        if (result) {
            this.listener.getLogger().format("[SSH Mina] Server host key verified%n", new Object[0]);
        } else {
            this.listener.getLogger().format("[SSH Mina] Server host key rejected%n", new Object[0]);
        }
        LOGGER.log(Level.FINE, () -> "verifier " + this.delegate.getClass().getName() + " return " + result + " for host " + String.valueOf(clientSession.getRemoteAddress()) + " publicKey: " + String.valueOf(serverKey));
        return result;
    }
}

