/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.SCPClient;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.ServerHostKeyVerifier;
import com.trilead.ssh2.Session;
import com.trilead.ssh2.jenkins.SFTPClient;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.Messages;
import hudson.plugins.sshslaves.PluginImpl;
import hudson.plugins.sshslaves.SSHConnector;
import hudson.plugins.sshslaves.verifiers.HostKey;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.slaves.SlaveComputer;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.NamingThreadFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.security.core.Authentication;

@Deprecated
public class SSHLauncher
extends ComputerLauncher {
    public static final SchemeRequirement SSH_SCHEME = new SchemeRequirement("ssh");
    public static final Integer DEFAULT_MAX_NUM_RETRIES = 10;
    public static final Integer DEFAULT_RETRY_WAIT_TIME = 15;
    public static final Integer DEFAULT_LAUNCH_TIMEOUT_SECONDS = 60;
    public static final String AGENT_JAR = "remoting.jar";
    public static final String SLASH_AGENT_JAR = "/remoting.jar";
    public static final String WORK_DIR_PARAM = " -workDir ";
    public static final String JAR_CACHE_PARAM = " -jar-cache ";
    public static final String JAR_CACHE_DIR = "/remoting/jarCache";
    public static final int DEFAULT_SSH_PORT = 22;
    private String host;
    private int port;
    private String credentialsId;
    private transient StandardUsernameCredentials credentials;
    private String jvmOptions;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String javaPath;
    private volatile transient Connection connection;
    private volatile transient boolean tearingDownConnection;
    private transient Session session;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String prefixStartSlaveCmd;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public String suffixStartSlaveCmd;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public Integer launchTimeoutSeconds;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public Integer maxNumRetries;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility.")
    public Integer retryWaitTime;
    @CheckForNull
    private volatile transient ExecutorService launcherExecutorService;
    @CheckForNull
    private SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy;
    private Boolean tcpNoDelay;
    private String workDir;
    private static final Logger LOGGER = Logger.getLogger(SSHLauncher.class.getName());

    public SSHLauncher(@NonNull String host, int port, String credentialsId, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, @CheckForNull SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
        this.setHost(host);
        this.setJvmOptions(jvmOptions);
        this.setPort(port);
        this.credentialsId = credentialsId;
        this.setJavaPath(javaPath);
        this.setPrefixStartSlaveCmd(prefixStartSlaveCmd);
        this.setSuffixStartSlaveCmd(suffixStartSlaveCmd);
        this.setLaunchTimeoutSeconds(launchTimeoutSeconds);
        this.setMaxNumRetries(maxNumRetries);
        this.setRetryWaitTime(retryWaitTime);
        this.sshHostKeyVerificationStrategy = sshHostKeyVerificationStrategy;
    }

    @DataBoundConstructor
    public SSHLauncher(@NonNull String host, int port, String credentialsId) {
        this.setHost(host);
        this.setPort(port);
        this.credentialsId = credentialsId;
        this.launchTimeoutSeconds = DEFAULT_LAUNCH_TIMEOUT_SECONDS;
        this.maxNumRetries = DEFAULT_MAX_NUM_RETRIES;
        this.retryWaitTime = DEFAULT_RETRY_WAIT_TIME;
    }

    public static StandardUsernameCredentials lookupSystemCredentials(String credentialsId) {
        return (StandardUsernameCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(StandardUsernameCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, List.of(SSH_SCHEME)), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public Object readResolve() {
        if (this.tcpNoDelay == null) {
            this.tcpNoDelay = true;
        }
        if (this.launchTimeoutSeconds == null || this.launchTimeoutSeconds <= 0 || this.launchTimeoutSeconds == 210) {
            this.launchTimeoutSeconds = DEFAULT_LAUNCH_TIMEOUT_SECONDS;
        }
        if (this.maxNumRetries == null) {
            this.maxNumRetries = DEFAULT_MAX_NUM_RETRIES;
        }
        if (this.retryWaitTime == null) {
            this.retryWaitTime = DEFAULT_RETRY_WAIT_TIME;
        }
        return this;
    }

    public StandardUsernameCredentials getCredentials() {
        String credentialsId = this.credentialsId == null ? (this.credentials == null ? null : this.credentials.getId()) : this.credentialsId;
        try {
            StandardUsernameCredentials credentials;
            StandardUsernameCredentials standardUsernameCredentials = credentials = credentialsId != null ? SSHLauncher.lookupSystemCredentials(credentialsId) : null;
            if (credentials != null) {
                this.credentials = credentials;
                return credentials;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return this.credentials;
    }

    public boolean isLaunchSupported() {
        return true;
    }

    public String getJvmOptions() {
        return this.jvmOptions == null ? "" : this.jvmOptions;
    }

    @Deprecated
    public String getJavaPath() {
        return this.javaPath == null ? "" : this.javaPath;
    }

    @Restricted(value={NoExternalUse.class})
    public static String getTimestamp() {
        return String.format("[%1$tD %1$tT]", new Date());
    }

    @CheckForNull
    public static String getWorkingDirectory(SlaveComputer computer) {
        return SSHLauncher.getWorkingDirectory(computer.getNode());
    }

    @CheckForNull
    private static String getWorkingDirectory(@CheckForNull Slave agent) {
        if (agent == null) {
            return null;
        }
        String workingDirectory = agent.getRemoteFS();
        while (workingDirectory.endsWith("/")) {
            workingDirectory = workingDirectory.substring(0, workingDirectory.length() - 1);
        }
        return workingDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(SlaveComputer computer, TaskListener listener) throws InterruptedException {
        Slave node = computer.getNode();
        String host = this.host;
        int port = this.port;
        this.checkConfig();
        SSHLauncher sSHLauncher = this;
        synchronized (sSHLauncher) {
            if (this.connection != null) {
                listener.getLogger().println(Messages.SSHLauncher_alreadyConnected());
                return;
            }
            this.connection = new Connection(host, port);
            this.launcherExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamingThreadFactory(Executors.defaultThreadFactory(), "SSHLauncher.launch for '" + computer.getName() + "' node"));
            HashSet<Callable<Boolean>> callables = new HashSet<Callable<Boolean>>();
            callables.add(() -> {
                Boolean rval = Boolean.FALSE;
                try {
                    String[] preferredKeyAlgorithms = this.getSshHostKeyVerificationStrategyDefaulted().getPreferredKeyAlgorithms(computer);
                    if (preferredKeyAlgorithms != null && preferredKeyAlgorithms.length > 0) {
                        this.connection.setServerHostKeyAlgorithms(preferredKeyAlgorithms);
                    } else {
                        listener.getLogger().println("Warning: no key algorithms provided; JENKINS-42959 disabled");
                    }
                    listener.getLogger().println(this.logConfiguration());
                    this.openConnection(listener, computer);
                    this.verifyNoHeaderJunk(listener);
                    this.reportEnvironment(listener);
                    String workingDirectory = SSHLauncher.getWorkingDirectory(computer);
                    if (workingDirectory == null) {
                        listener.error("Cannot get the working directory for " + String.valueOf(computer));
                        Boolean bl = Boolean.FALSE;
                        return bl;
                    }
                    String java = "java";
                    if (StringUtils.isNotBlank((CharSequence)this.javaPath)) {
                        java = this.expandExpression(computer, this.javaPath);
                    }
                    this.copyAgentJar(listener, workingDirectory);
                    this.startAgent(computer, listener, java, workingDirectory);
                    PluginImpl.register(this.connection);
                    rval = Boolean.TRUE;
                    return rval;
                }
                catch (Error | RuntimeException e) {
                    String msg = Messages.SSHLauncher_UnexpectedError();
                    if (StringUtils.isNotBlank((CharSequence)e.getMessage())) {
                        msg = e.getMessage();
                    }
                    e.printStackTrace(listener.error(msg));
                }
                catch (AbortException e) {
                    listener.getLogger().println(e.getMessage());
                }
                catch (IOException e) {
                    e.printStackTrace(listener.getLogger());
                }
                finally {
                    return rval;
                }
            });
            String nodeName = node != null ? node.getNodeName() : "unknown";
            try {
                Boolean res;
                long time = System.currentTimeMillis();
                ExecutorService srv = this.launcherExecutorService;
                if (srv == null) {
                    throw new IllegalStateException("Launcher Executor Service should be always non-null here, because the task allocates and closes service on its own");
                }
                List results = srv.invokeAll(callables);
                long duration = System.currentTimeMillis() - time;
                try {
                    res = (Boolean)results.get(0).get();
                }
                catch (CancellationException | ExecutionException e) {
                    res = Boolean.FALSE;
                    listener.getLogger().println(Messages.SSHLauncher_launchCanceled());
                }
                if (!res.booleanValue()) {
                    LOGGER.warning(() -> Messages.SSHLauncher_LaunchFailedDuration(nodeName, host, duration));
                    listener.getLogger().println(SSHLauncher.getTimestamp() + " Launch failed - cleaning up connection");
                    this.cleanupConnection(listener);
                } else {
                    LOGGER.fine(() -> Messages.SSHLauncher_LaunchCompletedDuration(nodeName, host, duration));
                }
            }
            catch (InterruptedException e) {
                LOGGER.warning(() -> Messages.SSHLauncher_LaunchFailed(nodeName, host));
            }
            finally {
                this.shutdownAndAwaitTerminationOfLauncher();
            }
        }
        if (node != null && this.getTrackCredentials()) {
            CredentialsProvider.track((Node)node, (Credentials)this.getCredentials());
        }
    }

    private void checkJavaIsInPath(TaskListener listener) {
        String msg = "Java is not in the PATH nor configured with the javaPath setting, Jenkins will try to guess where is Java, this guess will be removed in the future. :" + this.getDescriptor().getDisplayName();
        int ret = 0;
        try {
            listener.getLogger().println("Checking Java version in the PATH");
            ret = this.connection.exec("java -version", (OutputStream)listener.getLogger());
        }
        catch (Exception e) {
            ret = -1;
        }
        if (ret != 0) {
            LOGGER.log(Level.WARNING, msg);
            listener.getLogger().println(msg);
        }
    }

    private void cleanupConnection(TaskListener listener) {
        Connection _connection = this.connection;
        if (_connection != null) {
            Computer.threadPoolForRemoting.submit(() -> ((Connection)_connection).close());
            this.connection = null;
            listener.getLogger().println(Messages.SSHLauncher_ConnectionClosed(SSHLauncher.getTimestamp()));
        }
    }

    private String expandExpression(SlaveComputer computer, String expression) {
        return this.getEnvVars(computer).expand(expression);
    }

    private EnvVars getEnvVars(SlaveComputer computer) {
        EnvVars local;
        EnvVars global = this.getEnvVars(Jenkins.get());
        Slave node = computer.getNode();
        EnvVars envVars = local = node != null ? this.getEnvVars((Node)node) : null;
        if (global != null) {
            if (local != null) {
                EnvVars merged = new EnvVars(global);
                merged.overrideAll((Map)local);
                return merged;
            }
            return global;
        }
        if (local != null) {
            return local;
        }
        return new EnvVars();
    }

    private EnvVars getEnvVars(Jenkins h) {
        return this.getEnvVars(h.getGlobalNodeProperties());
    }

    private EnvVars getEnvVars(Node n) {
        return this.getEnvVars(n.getNodeProperties());
    }

    private EnvVars getEnvVars(DescribableList<NodeProperty<?>, NodePropertyDescriptor> dl) {
        EnvironmentVariablesNodeProperty evnp = (EnvironmentVariablesNodeProperty)dl.get(EnvironmentVariablesNodeProperty.class);
        if (evnp == null) {
            return null;
        }
        return evnp.getEnvVars();
    }

    private void verifyNoHeaderJunk(TaskListener listener) throws IOException, InterruptedException {
        String s;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.connection.exec("exit 0", (OutputStream)baos);
        try {
            s = baos.toString(Charset.defaultCharset().name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IOException("Default encoding is unsupported", ex);
        }
        if (s.length() != 0) {
            listener.getLogger().println(Messages.SSHLauncher_SSHHeaderJunkDetected());
            listener.getLogger().println(s);
            throw new AbortException();
        }
    }

    private void startAgent(SlaveComputer computer, TaskListener listener, String java, String workingDirectory) throws IOException {
        this.session = this.connection.openSession();
        this.expandChannelBufferSize(this.session, listener);
        String cmd = "cd \"" + workingDirectory + "\" && " + java + " " + this.getJvmOptions() + " -jar remoting.jar" + this.getWorkDirParam(workingDirectory);
        cmd = this.getPrefixStartSlaveCmd() + cmd + this.getSuffixStartSlaveCmd();
        listener.getLogger().println(Messages.SSHLauncher_StartingAgentProcess(SSHLauncher.getTimestamp(), cmd));
        this.session.execCommand(cmd);
        this.session.pipeStderr((OutputStream)new DelegateNoCloseOutputStream(listener.getLogger()));
        try {
            computer.setChannel(this.session.getStdout(), this.session.getStdin(), (OutputStream)listener.getLogger(), null);
        }
        catch (InterruptedException e) {
            this.session.close();
            throw new IOException(Messages.SSHLauncher_AbortedDuringConnectionOpen(), e);
        }
        catch (IOException e) {
            try {
                throw new AbortException(this.getSessionOutcomeMessage(this.session, false));
            }
            catch (InterruptedException x) {
                throw new IOException(e);
            }
        }
    }

    private void expandChannelBufferSize(Session session, TaskListener listener) {
        int sz = 4;
        session.setWindowSize(sz * 1024 * 1024);
        listener.getLogger().println("Expanded the channel window size to " + sz + "MB");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyAgentJar(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        block26: {
            String fileName = workingDirectory + SLASH_AGENT_JAR;
            listener.getLogger().println(Messages.SSHLauncher_StartingSFTPClient(SSHLauncher.getTimestamp()));
            try (SFTPClient sftpClient = null;){
                sftpClient = new SFTPClient(this.connection);
                try {
                    SFTPv3FileAttributes fileAttributes = sftpClient._stat(workingDirectory);
                    if (fileAttributes == null) {
                        listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(SSHLauncher.getTimestamp(), workingDirectory));
                        sftpClient.mkdirs(workingDirectory, 448);
                    } else if (fileAttributes.isRegularFile()) {
                        throw new IOException(Messages.SSHLauncher_RemoteFSIsAFile(workingDirectory));
                    }
                    listener.getLogger().println(Messages.SSHLauncher_CopyingAgentJar(SSHLauncher.getTimestamp()));
                    byte[] agentJar = new Slave.JnlpJar(AGENT_JAR).readFully();
                    boolean overwrite = true;
                    if (sftpClient.exists(fileName)) {
                        String sourceAgentHash = SSHLauncher.getMd5Hash(agentJar);
                        String existingAgentHash = SSHLauncher.getMd5Hash(SSHLauncher.readInputStreamIntoByteArrayAndClose(sftpClient.read(fileName)));
                        listener.getLogger().println(MessageFormat.format("Source agent hash is {0}. Installed agent hash is {1}", sourceAgentHash, existingAgentHash));
                        boolean bl = overwrite = !sourceAgentHash.equals(existingAgentHash);
                    }
                    if (overwrite) {
                        try {
                            sftpClient.rm(fileName);
                        }
                        catch (IOException sourceAgentHash) {
                            // empty catch block
                        }
                        try (OutputStream os = sftpClient.writeToFile(fileName);){
                            os.write(agentJar);
                            listener.getLogger().println(Messages.SSHLauncher_CopiedXXXBytes(SSHLauncher.getTimestamp(), agentJar.length));
                            break block26;
                        }
                        catch (Error error) {
                            throw error;
                        }
                        catch (Throwable e) {
                            throw new IOException(Messages.SSHLauncher_ErrorCopyingAgentJarTo(fileName), e);
                        }
                    }
                    listener.getLogger().println("Verified agent jar. No update is necessary.");
                }
                catch (Error error) {
                    throw error;
                }
                catch (Throwable e) {
                    throw new IOException(Messages.SSHLauncher_ErrorCopyingAgentJarInto(workingDirectory), e);
                }
            }
        }
    }

    static String getMd5Hash(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(bytes);
        byte[] digest = md.digest();
        char[] hexCode = "0123456789ABCDEF".toCharArray();
        StringBuilder r = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            r.append(hexCode[b >> 4 & 0xF]);
            r.append(hexCode[b & 0xF]);
        }
        String hash = r.toString().toUpperCase();
        return hash;
    }

    static byte[] readInputStreamIntoByteArrayAndClose(InputStream inputStream) throws IOException {
        byte[] bytes = null;
        try {
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            if (bytes == null) {
                bytes = new byte[1];
            }
        }
        return bytes;
    }

    private void copySlaveJarUsingSCP(TaskListener listener, String workingDirectory) throws IOException, InterruptedException {
        SCPClient scp = new SCPClient(this.connection);
        try {
            if (this.connection.exec("test -d " + workingDirectory, (OutputStream)listener.getLogger()) != 0) {
                listener.getLogger().println(Messages.SSHLauncher_RemoteFSDoesNotExist(SSHLauncher.getTimestamp(), workingDirectory));
                if (this.connection.exec("mkdir -p " + workingDirectory, (OutputStream)listener.getLogger()) != 0) {
                    listener.getLogger().println("Failed to create " + workingDirectory);
                }
            }
            this.connection.exec("rm " + workingDirectory + SLASH_AGENT_JAR, OutputStream.nullOutputStream());
            listener.getLogger().println(Messages.SSHLauncher_CopyingAgentJar(SSHLauncher.getTimestamp()));
            scp.put(new Slave.JnlpJar(AGENT_JAR).readFully(), AGENT_JAR, workingDirectory, "0644");
        }
        catch (IOException e) {
            throw new IOException(Messages.SSHLauncher_ErrorCopyingAgentJarInto(workingDirectory), e);
        }
    }

    protected void reportEnvironment(TaskListener listener) throws IOException, InterruptedException {
        listener.getLogger().println(Messages._SSHLauncher_RemoteUserEnvironment(SSHLauncher.getTimestamp()));
        this.connection.exec("set", (OutputStream)listener.getLogger());
    }

    protected void openConnection(TaskListener listener, SlaveComputer computer) throws IOException, InterruptedException {
        StandardUsernameCredentials credentials;
        PrintStream logger = listener.getLogger();
        logger.println(Messages.SSHLauncher_OpeningSSHConnection(SSHLauncher.getTimestamp(), this.host + ":" + this.port));
        this.connection.setTCPNoDelay(this.getTcpNoDelay());
        int maxNumRetries = this.getMaxNumRetries();
        for (int i = 0; i <= maxNumRetries; ++i) {
            try {
                int launchTimeoutMillis = (int)this.getLaunchTimeoutMillis();
                this.connection.connect((ServerHostKeyVerifier)new ServerHostKeyVerifierImpl(computer, listener), launchTimeoutMillis, 0, (int)((long)launchTimeoutMillis + TimeUnit.SECONDS.toMillis(5L)));
                break;
            }
            catch (Exception ex) {
                String message = "unknown error";
                Throwable cause = ex.getCause();
                if (cause != null) {
                    message = cause.getMessage();
                    logger.println(message);
                } else if (ex.getMessage() != null) {
                    message = ex.getMessage();
                    logger.println(message);
                }
                this.connection.close();
                if (maxNumRetries - i > 0) {
                    logger.println("SSH Connection failed with IOException: \"" + message + "\", retrying in " + this.getRetryWaitTime() + " seconds. There are " + (maxNumRetries - i) + " more retries left.");
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.getRetryWaitTime().intValue()));
                continue;
            }
        }
        if ((credentials = this.getCredentials()) == null) {
            throw new AbortException("Cannot find SSH User credentials with id: " + this.credentialsId);
        }
        if (!SSHAuthenticator.newInstance((Object)this.connection, (StandardUsernameCredentials)credentials).authenticate(listener) || !this.connection.isAuthenticationComplete()) {
            logger.println(Messages.SSHLauncher_AuthenticationFailed(SSHLauncher.getTimestamp()));
            throw new AbortException(Messages.SSHLauncher_AuthenticationFailedException());
        }
        logger.println(Messages.SSHLauncher_AuthenticationSuccessful(SSHLauncher.getTimestamp()));
    }

    private void checkConfig() throws InterruptedException {
        Descriptor descriptorOrg = Jenkins.get().getDescriptor(((Object)((Object)this)).getClass());
        if (!(descriptorOrg instanceof DescriptorImpl)) {
            return;
        }
        DescriptorImpl descriptor = (DescriptorImpl)descriptorOrg;
        Object message = "Validate configuration:\n";
        boolean isValid = true;
        String port = String.valueOf(this.port);
        FormValidation validatePort = descriptor.doCheckPort(port);
        FormValidation validateHost = descriptor.doCheckHost(this.host);
        FormValidation validateCredentials = descriptor.doCheckCredentialsId((ItemGroup)Jenkins.get(), (AccessControlled)Jenkins.get(), this.host, port, this.credentialsId);
        if (validatePort.kind == FormValidation.Kind.ERROR) {
            isValid = false;
            message = (String)message + validatePort.getMessage() + "\n";
        }
        if (validateHost.kind == FormValidation.Kind.ERROR) {
            isValid = false;
            message = (String)message + validateHost.getMessage() + "\n";
        }
        if (validateCredentials.kind == FormValidation.Kind.ERROR) {
            isValid = false;
            message = (String)message + validateCredentials.getMessage() + "\n";
        }
        if (!isValid) {
            throw new InterruptedException((String)message);
        }
    }

    public void afterDisconnect(SlaveComputer slaveComputer, TaskListener listener) {
        if (this.connection == null) {
            return;
        }
        this.shutdownAndAwaitTerminationOfLauncher();
        if (this.tearingDownConnection) {
            LOGGER.log(Level.FINE, "There is already a tear down operation in progress for connection {0}. Skipping the call", this.connection);
            return;
        }
        this.tearDownConnection(slaveComputer, listener);
    }

    private synchronized void tearDownConnection(@NonNull SlaveComputer slaveComputer, @NonNull TaskListener listener) {
        if (this.connection != null) {
            this.tearDownConnectionImpl(slaveComputer, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tearDownConnectionImpl(@NonNull SlaveComputer slaveComputer, @NonNull TaskListener listener) {
        try {
            this.tearingDownConnection = true;
            boolean connectionLost = this.reportTransportLoss(this.connection, listener);
            if (this.session != null) {
                try {
                    listener.getLogger().println(this.getSessionOutcomeMessage(this.session, connectionLost));
                    this.session.getStdout().close();
                    this.session.close();
                }
                catch (Throwable t) {
                    t.printStackTrace(listener.error(Messages.SSHLauncher_ErrorWhileClosingConnection()));
                }
                this.session = null;
            }
            PluginImpl.unregister(this.connection);
            this.cleanupConnection(listener);
        }
        finally {
            this.tearingDownConnection = false;
        }
    }

    private void shutdownAndAwaitTerminationOfLauncher() {
        ExecutorService srv = this.launcherExecutorService;
        if (srv == null) {
            return;
        }
        srv.shutdown();
        this.launcherExecutorService = null;
        try {
            if (!srv.awaitTermination(10L, TimeUnit.SECONDS)) {
                srv.shutdownNow();
                if (!srv.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.log(Level.WARNING, "launcherExecutorService thread pool did not terminate cleanly");
                }
            }
        }
        catch (InterruptedException ie) {
            srv.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private boolean reportTransportLoss(Connection c, TaskListener listener) {
        Throwable cause = c.getReasonClosedCause();
        if (cause != null) {
            cause.printStackTrace(listener.error("Socket connection to SSH server was lost"));
        }
        return cause != null;
    }

    private String getSessionOutcomeMessage(Session session, boolean isConnectionLost) throws InterruptedException {
        session.waitForCondition(96, 3000L);
        Integer exitCode = session.getExitStatus();
        if (exitCode != null) {
            return "Agent JVM has terminated. Exit code=" + exitCode;
        }
        String sig = session.getExitSignal();
        if (sig != null) {
            return "Agent JVM has terminated. Exit signal=" + sig;
        }
        if (isConnectionLost) {
            return "Agent JVM has not reported exit code before the socket was lost";
        }
        return "Agent JVM has not reported exit code. Is it still running?";
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategy() {
        return this.sshHostKeyVerificationStrategy;
    }

    @NonNull
    SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategyDefaulted() {
        return this.sshHostKeyVerificationStrategy != null ? this.sshHostKeyVerificationStrategy : new NonVerifyingKeyVerificationStrategy();
    }

    @DataBoundSetter
    public void setSshHostKeyVerificationStrategy(@CheckForNull SshHostKeyVerificationStrategy value) {
        this.sshHostKeyVerificationStrategy = value;
    }

    @DataBoundSetter
    public void setJvmOptions(String value) {
        this.jvmOptions = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setJavaPath(String value) {
        this.javaPath = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setPrefixStartSlaveCmd(String value) {
        this.prefixStartSlaveCmd = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setSuffixStartSlaveCmd(String value) {
        this.suffixStartSlaveCmd = Util.fixEmpty((String)value);
    }

    @DataBoundSetter
    public void setMaxNumRetries(Integer value) {
        this.maxNumRetries = value != null && value >= 0 ? value : DEFAULT_MAX_NUM_RETRIES;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer value) {
        this.launchTimeoutSeconds = value == null || value <= 0 ? DEFAULT_LAUNCH_TIMEOUT_SECONDS : value;
    }

    @DataBoundSetter
    public void setRetryWaitTime(Integer value) {
        this.retryWaitTime = value != null && value >= 0 ? value : DEFAULT_RETRY_WAIT_TIME;
    }

    public void setPort(int value) {
        this.port = value == 0 ? 22 : value;
    }

    public void setHost(String value) {
        this.host = Util.fixEmptyAndTrim((String)value);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Connection getConnection() {
        return this.connection;
    }

    @NonNull
    public String getPrefixStartSlaveCmd() {
        return Util.fixNull((String)this.prefixStartSlaveCmd);
    }

    @NonNull
    public String getSuffixStartSlaveCmd() {
        return Util.fixNull((String)this.suffixStartSlaveCmd);
    }

    @NonNull
    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    private long getLaunchTimeoutMillis() {
        return this.launchTimeoutSeconds == null || this.launchTimeoutSeconds < 0 ? (long)DEFAULT_LAUNCH_TIMEOUT_SECONDS.intValue() : TimeUnit.SECONDS.toMillis(this.launchTimeoutSeconds.intValue());
    }

    @NonNull
    public Integer getMaxNumRetries() {
        return this.maxNumRetries == null || this.maxNumRetries < 0 ? DEFAULT_MAX_NUM_RETRIES : this.maxNumRetries;
    }

    @NonNull
    public Integer getRetryWaitTime() {
        return this.retryWaitTime == null || this.retryWaitTime < 0 ? DEFAULT_RETRY_WAIT_TIME : this.retryWaitTime;
    }

    public boolean getTcpNoDelay() {
        return this.tcpNoDelay != null ? this.tcpNoDelay : true;
    }

    @DataBoundSetter
    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean getTrackCredentials() {
        String trackCredentials = System.getProperty(SSHLauncher.class.getName() + ".trackCredentials");
        return !"false".equalsIgnoreCase(trackCredentials);
    }

    public String getWorkDir() {
        return this.workDir;
    }

    @DataBoundSetter
    public void setWorkDir(String workDir) {
        this.workDir = Util.fixEmptyAndTrim((String)workDir);
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    public String getWorkDirParam(@NonNull String workingDirectory) {
        Object ret = this.getSuffixStartSlaveCmd().contains(WORK_DIR_PARAM) || this.getSuffixStartSlaveCmd().contains(JAR_CACHE_PARAM) ? "" : (StringUtils.isNotBlank((CharSequence)this.getWorkDir()) ? WORK_DIR_PARAM + this.getWorkDir() + JAR_CACHE_PARAM + this.getWorkDir() + JAR_CACHE_DIR : WORK_DIR_PARAM + workingDirectory + JAR_CACHE_PARAM + workingDirectory + JAR_CACHE_DIR);
        return ret;
    }

    public String logConfiguration() {
        StringBuilder sb = new StringBuilder("SSHLauncher{");
        sb.append("host='").append(this.getHost()).append('\'');
        sb.append(", port=").append(this.getPort());
        sb.append(", credentialsId='").append(Util.fixNull((String)this.credentialsId)).append('\'');
        sb.append(", jvmOptions='").append(this.getJvmOptions()).append('\'');
        sb.append(", javaPath='").append(Util.fixNull((String)this.javaPath)).append('\'');
        sb.append(", prefixStartSlaveCmd='").append(this.getPrefixStartSlaveCmd()).append('\'');
        sb.append(", suffixStartSlaveCmd='").append(this.getSuffixStartSlaveCmd()).append('\'');
        sb.append(", launchTimeoutSeconds=").append(this.getLaunchTimeoutSeconds());
        sb.append(", maxNumRetries=").append(this.getMaxNumRetries());
        sb.append(", retryWaitTime=").append(this.getRetryWaitTime());
        sb.append(", sshHostKeyVerificationStrategy=").append(this.sshHostKeyVerificationStrategy != null ? this.sshHostKeyVerificationStrategy.getClass().getName() : "None");
        sb.append(", tcpNoDelay=").append(this.getTcpNoDelay());
        sb.append(", trackCredentials=").append(this.getTrackCredentials());
        sb.append('}');
        return sb.toString();
    }

    private static class DelegateNoCloseOutputStream
    extends OutputStream {
        private OutputStream out;

        public DelegateNoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void close() throws IOException {
            this.out = null;
        }

        @Override
        public void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        @Override
        public void write(@NonNull byte[] b) throws IOException {
            if (this.out != null) {
                this.out.write(b);
            }
        }

        @Override
        public void write(@NonNull byte[] b, int off, int len) throws IOException {
            if (this.out != null) {
                this.out.write(b, off, len);
            }
        }
    }

    private class ServerHostKeyVerifierImpl
    implements ServerHostKeyVerifier {
        private final SlaveComputer computer;
        private final TaskListener listener;

        public ServerHostKeyVerifierImpl(SlaveComputer computer, TaskListener listener) {
            this.computer = computer;
            this.listener = listener;
        }

        public boolean verifyServerHostKey(String hostname, int port, String serverHostKeyAlgorithm, byte[] serverHostKey) throws Exception {
            HostKey key = new HostKey(serverHostKeyAlgorithm, serverHostKey);
            return SSHLauncher.this.getSshHostKeyVerificationStrategyDefaulted().verify(this.computer, key, this.listener);
        }
    }

    @Extension
    @Symbol(value={"ssh", "sSHLauncher"})
    public static class DescriptorImpl
    extends Descriptor<ComputerLauncher> {
        @NonNull
        public String getDisplayName() {
            return Messages.SSHLauncher_DescriptorDisplayName();
        }

        public Class getSshConnectorClass() {
            return SSHConnector.class;
        }

        public String getHelpFile(String fieldName) {
            String n = super.getHelpFile(fieldName);
            if (n == null) {
                n = Jenkins.get().getDescriptorOrDie(SSHConnector.class).getHelpFile(fieldName);
            }
            return n;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath AccessControlled context, @QueryParameter String host, @QueryParameter String port, @QueryParameter String credentialsId) {
            Jenkins jenkins = Jenkins.get();
            if (context == jenkins && !jenkins.hasPermission(Computer.CREATE) || context != jenkins && !context.hasPermission(Computer.CONFIGURE)) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
            try {
                int portValue = Integer.parseInt(port);
                return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM2, (ItemGroup)jenkins, StandardUsernameCredentials.class, Collections.singletonList(new HostnamePortRequirement(host, portValue)), SSHAuthenticator.matcher(Connection.class)).includeCurrentValue(credentialsId);
            }
            catch (NumberFormatException ex) {
                return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
            }
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(@AncestorInPath ItemGroup context, @AncestorInPath AccessControlled _context, @QueryParameter String host, @QueryParameter String port, @QueryParameter String value) {
            Jenkins jenkins = Jenkins.get();
            if (_context == jenkins && !jenkins.hasPermission(Computer.CREATE) || _context != jenkins && !_context.hasPermission(Computer.CONFIGURE)) {
                return FormValidation.ok();
            }
            try {
                int portValue = Integer.parseInt(port);
                for (ListBoxModel.Option o : CredentialsProvider.listCredentialsInItemGroup(StandardUsernameCredentials.class, (ItemGroup)context, (Authentication)ACL.SYSTEM2, Collections.singletonList(new HostnamePortRequirement(host, portValue)), (CredentialsMatcher)SSHAuthenticator.matcher(Connection.class))) {
                    if (!StringUtils.equals((CharSequence)value, (CharSequence)o.value)) continue;
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.warning((Throwable)e, (String)Messages.SSHLauncher_PortNotANumber());
            }
            return FormValidation.error((String)Messages.SSHLauncher_SelectedCredentialsMissing());
        }

        @RequirePOST
        public FormValidation doCheckPort(@QueryParameter String value) {
            Jenkins.get().checkPermission(Computer.CONFIGURE);
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.error((String)Messages.SSHLauncher_PortNotSpecified());
            }
            try {
                int portValue = Integer.parseInt(value);
                if (portValue <= 0) {
                    return FormValidation.error((String)Messages.SSHLauncher_PortLessThanZero());
                }
                if (portValue >= 65536) {
                    return FormValidation.error((String)Messages.SSHLauncher_PortMoreThan65535());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((Throwable)e, (String)Messages.SSHLauncher_PortNotANumber());
            }
        }

        @RequirePOST
        public FormValidation doCheckHost(@QueryParameter String value) {
            Jenkins.get().checkPermission(Computer.CONFIGURE);
            FormValidation ret = FormValidation.ok();
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.error((String)Messages.SSHLauncher_HostNotSpecified());
            }
            return ret;
        }

        @RequirePOST
        public FormValidation doCheckJavaPath(@QueryParameter String value) {
            Jenkins.get().checkPermission(Computer.CONFIGURE);
            FormValidation ret = FormValidation.ok();
            if (!(value == null || !value.contains(" ") || value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
                return FormValidation.warning((String)Messages.SSHLauncher_JavaPathHasWhiteSpaces());
            }
            return ret;
        }
    }
}

