/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.model.Computer;
import hudson.model.FreeStyleProject;
import hudson.model.Node;
import hudson.plugins.sshslaves.mina.MinaSSHContainerFactory;
import hudson.plugins.sshslaves.mina.MinaSSHLauncher;
import hudson.plugins.sshslaves.mina.MinaServerKeyVerificationStrategy;
import hudson.plugins.sshslaves.mina.TrustOnFirstUseVerificationStrategy;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.OfflineCause;
import hudson.slaves.RetentionStrategy;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Timeout(value=10L, unit=TimeUnit.MINUTES)
@WithJenkins
@Testcontainers(disabledWithoutDocker=true)
class MinaSSHLauncherWithKeyTest {
    @Container
    static GenericContainer<?> sshContainer = MinaSSHContainerFactory.createContainer("base");
    private JenkinsRule j;

    MinaSSHLauncherWithKeyTest() {
    }

    @BeforeEach
    void setUp(JenkinsRule j) {
        this.j = j;
    }

    @Test
    void sshConnectWithKey() throws Exception {
        String host = sshContainer.getHost();
        int port = sshContainer.getMappedPort(22);
        String privateKey = IOUtils.toString((InputStream)Objects.requireNonNull(Thread.currentThread().getContextClassLoader().getResourceAsStream("rsa2048")), (Charset)StandardCharsets.UTF_8);
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, "simpleCredentials", "foo", (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), "theaustraliancricketteamisthebest", null)));
        MinaSSHLauncher launcher = new MinaSSHLauncher(host, port, "simpleCredentials");
        launcher.setJavaPath("/usr/java/latest/bin/java");
        launcher.setServerKeyVerificationStrategy((MinaServerKeyVerificationStrategy)new TrustOnFirstUseVerificationStrategy(false));
        DumbSlave agent = new DumbSlave("agent" + this.j.jenkins.getNodes().size(), "/home/foo/agent", (ComputerLauncher)launcher);
        agent.setMode(Node.Mode.NORMAL);
        agent.setRetentionStrategy((RetentionStrategy)RetentionStrategy.INSTANCE);
        this.j.jenkins.addNode((Node)agent);
        Computer computer = agent.toComputer();
        try {
            computer.connect(false).get();
        }
        catch (ExecutionException x) {
            throw new AssertionError("failed to connect: " + computer.getLog(), x);
        }
        MatcherAssert.assertThat((Object)computer.getLog(), (Matcher)Matchers.containsString((String)"Agent successfully connected and online"));
        FreeStyleProject p = this.j.createFreeStyleProject();
        p.setAssignedNode((Node)agent);
        try {
            computer.disconnect(OfflineCause.create(null)).get();
        }
        catch (ExecutionException x) {
            throw new AssertionError("failed to disconnect: " + computer.getLog(), x);
        }
        Awaitility.await().atMost(Duration.ofSeconds(30L)).until(() -> computer.getLog().contains("Connection terminated"));
        try {
            computer.connect(true).get();
        }
        catch (ExecutionException x) {
            throw new AssertionError("failed to connect: " + computer.getLog(), x);
        }
        MatcherAssert.assertThat((Object)computer.getLog(), (Matcher)Matchers.containsString((String)"Agent successfully connected and online"));
        this.j.buildAndAssertSuccess(p);
    }
}

