/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.mina;

import hudson.model.Node;
import hudson.plugins.sshslaves.mina.BlindTrustVerificationStrategy;
import hudson.plugins.sshslaves.mina.MinaSSHLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.plugins.casc.misc.junit.jupiter.AbstractRoundTripTest;
import org.junit.jupiter.api.Assertions;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class MinaSSHLauncherCasCRoundTripTest
extends AbstractRoundTripTest {
    MinaSSHLauncherCasCRoundTripTest() {
    }

    protected void assertConfiguredAsExpected(JenkinsRule jenkins, String s) {
        Node node = jenkins.jenkins.getNode("mina-ssh-agent");
        Assertions.assertNotNull((Object)node);
        SlaveComputer computer = (SlaveComputer)node.toComputer();
        Assertions.assertNotNull((Object)computer);
        MinaSSHLauncher launcher = (MinaSSHLauncher)Assertions.assertInstanceOf(MinaSSHLauncher.class, (Object)computer.getLauncher());
        Assertions.assertEquals((Object)"ssh-host", (Object)launcher.getHost());
        Assertions.assertEquals((int)2222, (int)launcher.getPort());
        Assertions.assertEquals((Object)"-Xmx256m", (Object)launcher.getJvmOptions());
        Assertions.assertEquals((Object)"creds", (Object)launcher.getCredentialsId());
        Assertions.assertInstanceOf(BlindTrustVerificationStrategy.class, (Object)launcher.getServerKeyVerificationStrategy());
    }

    protected String stringInLogExpected() {
        return "Setting class hudson.plugins.sshslaves.mina.MinaSSHLauncher.host = ssh-host";
    }

    protected String configResource() {
        return "MinaSSHCasCConfig.yml";
    }
}

