/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Node;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.ManuallyTrustedKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.TrustHostKeyAction;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.slaves.RetentionStrategy;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.net.ServerSocket;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.htmlunit.html.HtmlPage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class TrustHostKeyActionTest {
    @TempDir
    private File temporaryFolder;

    TrustHostKeyActionTest() {
    }

    private static int findPort() throws IOException {
        try (ServerSocket socket = new ServerSocket();){
            socket.bind(null);
            int n = socket.getLocalPort();
            return n;
        }
    }

    @Test
    void testSubmitNotAuthorised(JenkinsRule jenkins) throws Exception {
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, "dummyCredentialId", null, "user", "pass")));
        int port = TrustHostKeyActionTest.findPort();
        try {
            Object server = TrustHostKeyActionTest.newSshServer();
            Assertions.assertNotNull((Object)server);
            Class<?> keyPairProviderClass = TrustHostKeyActionTest.newKeyPairProviderClass();
            Object provider = TrustHostKeyActionTest.newProvider();
            Assertions.assertNotNull((Object)provider);
            Object factory = TrustHostKeyActionTest.newFactory();
            Assertions.assertNotNull((Object)factory);
            Class<?> commandFactoryClass = TrustHostKeyActionTest.newCommandFactoryClass();
            Object commandFactory = TrustHostKeyActionTest.newCommandFactory(commandFactoryClass);
            Assertions.assertNotNull((Object)commandFactory);
            Class<?> commandAuthenticatorClass = TrustHostKeyActionTest.newCommandAuthenticatorClass();
            Object authenticator = TrustHostKeyActionTest.newAuthenticator(commandAuthenticatorClass);
            Assertions.assertNotNull((Object)authenticator);
            TrustHostKeyActionTest.invoke(server, "setPort", new Class[]{Integer.TYPE}, new Object[]{port});
            TrustHostKeyActionTest.invoke(server, "setKeyPairProvider", new Class[]{keyPairProviderClass}, new Object[]{provider});
            TrustHostKeyActionTest.invoke(server, "setUserAuthFactories", new Class[]{List.class}, new Object[]{Collections.singletonList(factory)});
            TrustHostKeyActionTest.invoke(server, "setCommandFactory", new Class[]{commandFactoryClass}, new Object[]{commandFactory});
            TrustHostKeyActionTest.invoke(server, "setPasswordAuthenticator", new Class[]{commandAuthenticatorClass}, new Object[]{authenticator});
            TrustHostKeyActionTest.invoke(server, "start", null, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AssertionError("Check sshd-core version", e);
        }
        SSHLauncher launcher = new SSHLauncher("localhost", port, "dummyCredentialId", null, "xyz", null, null, Integer.valueOf(30), Integer.valueOf(1), Integer.valueOf(1), (SshHostKeyVerificationStrategy)new ManuallyTrustedKeyVerificationStrategy(true));
        DumbSlave agent = new DumbSlave("test-agent", TrustHostKeyActionTest.newFolder(this.temporaryFolder, "junit").getAbsolutePath(), (ComputerLauncher)launcher);
        agent.setNodeDescription("SSH Test agent");
        agent.setRetentionStrategy(RetentionStrategy.NOOP);
        jenkins.getInstance().addNode((Node)agent);
        SlaveComputer computer = (SlaveComputer)jenkins.getInstance().getComputer("test-agent");
        Assertions.assertThrows(ExecutionException.class, () -> computer.connect(false).get());
        List actions = computer.getActions(TrustHostKeyAction.class);
        Assertions.assertEquals((int)1, (int)actions.size(), (String)computer.getLog());
        Assertions.assertNull((Object)((TrustHostKeyAction)actions.get(0)).getExistingHostKey());
        HtmlPage p = jenkins.createWebClient().getPage((Node)agent, ((TrustHostKeyAction)actions.get(0)).getUrlName());
        p.getElementByName("Yes").click();
        Assertions.assertTrue((boolean)((TrustHostKeyAction)actions.get(0)).isComplete());
        Assertions.assertEquals((Object)((TrustHostKeyAction)actions.get(0)).getExistingHostKey(), (Object)((TrustHostKeyAction)actions.get(0)).getHostKey());
    }

    private static Object newSshServer() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> serverClass;
        try {
            serverClass = Class.forName("org.apache.sshd.SshServer");
        }
        catch (ClassNotFoundException e) {
            serverClass = Class.forName("org.apache.sshd.server.SshServer");
        }
        return serverClass.getDeclaredMethod("setUpDefaultServer", new Class[0]).invoke(null, new Object[0]);
    }

    private static Class<?> newKeyPairProviderClass() throws ClassNotFoundException {
        Class<?> keyPairProviderClass;
        try {
            keyPairProviderClass = Class.forName("org.apache.sshd.common.KeyPairProvider");
        }
        catch (ClassNotFoundException e) {
            keyPairProviderClass = Class.forName("org.apache.sshd.common.keyprovider.KeyPairProvider");
        }
        return keyPairProviderClass;
    }

    private static Object newProvider() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> providerClass;
        try {
            providerClass = Class.forName("org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider");
        }
        catch (ClassNotFoundException e) {
            providerClass = Class.forName("org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider");
        }
        return providerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static Object newFactory() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<?> factoryClass;
        try {
            factoryClass = Class.forName("org.apache.sshd.server.auth.UserAuthPassword$Factory");
        }
        catch (ClassNotFoundException e) {
            factoryClass = Class.forName("org.apache.sshd.server.auth.password.UserAuthPasswordFactory");
        }
        return factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static Class<?> newCommandFactoryClass() throws ClassNotFoundException {
        return Class.forName("org.apache.sshd.server.command.CommandFactory");
    }

    private static Object newCommandFactory(Class<?> commandFactoryClass) throws IllegalArgumentException {
        return Proxy.newProxyInstance(commandFactoryClass.getClassLoader(), new Class[]{commandFactoryClass}, (proxy, method, args) -> {
            if (method.getName().equals("createCommand")) {
                Class<?> commandClass;
                try {
                    commandClass = Class.forName("org.apache.sshd.server.command.UnknownCommand");
                }
                catch (ClassNotFoundException e) {
                    commandClass = Class.forName("org.apache.sshd.server.scp.UnknownCommand");
                }
                return commandClass.getConstructor(String.class).newInstance(args[0]);
            }
            return null;
        });
    }

    private static Class<?> newCommandAuthenticatorClass() throws ClassNotFoundException {
        Class<?> passwordAuthenticatorClass;
        try {
            passwordAuthenticatorClass = Class.forName("org.apache.sshd.server.PasswordAuthenticator");
        }
        catch (ClassNotFoundException e) {
            passwordAuthenticatorClass = Class.forName("org.apache.sshd.server.auth.password.PasswordAuthenticator");
        }
        return passwordAuthenticatorClass;
    }

    private static Object newAuthenticator(Class<?> passwordAuthenticatorClass) throws IllegalArgumentException {
        return Proxy.newProxyInstance(passwordAuthenticatorClass.getClassLoader(), new Class[]{passwordAuthenticatorClass}, (proxy, method, args) -> {
            if (method.getName().equals("authenticate")) {
                return Boolean.TRUE;
            }
            return null;
        });
    }

    private static Object invoke(Object target, String methodName, Class<?>[] parameterTypes, Object[] args) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return target.getClass().getMethod(methodName, parameterTypes).invoke(target, args);
    }

    private static File newFolder(File root, String ... subDirs) throws IOException {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + String.valueOf(root));
        }
        return result;
    }
}

