/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves.verifiers;

import hudson.plugins.sshslaves.verifiers.JenkinsTrilead9VersionSupport;
import hudson.plugins.sshslaves.verifiers.TrileadVersionSupportManager;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TrileadVersionSupportManagerTest {
    TrileadVersionSupportManagerTest() {
    }

    @Test
    void testLegacyInstance() {
        BlockingClassloader classloader = TrileadVersionSupportManagerTest.newBlockingClassloader();
        classloader.block("com.trilead.ssh2.signature.KeyAlgorithmManager");
        Object trileadSupport = TrileadVersionSupportManagerTest.invokeGetTrileadSupport(classloader);
        Assertions.assertEquals((Object)"hudson.plugins.sshslaves.verifiers.TrileadVersionSupportManager$LegacyTrileadVersionSupport", (Object)trileadSupport.getClass().getName());
    }

    @Test
    void testLegacyInstanceWithLinkageError() {
        BlockingClassloader classloader = TrileadVersionSupportManagerTest.newBlockingClassloader();
        classloader.inspectPackage("com.trilead.ssh2.signature");
        classloader.block("com.trilead.ssh2.signature.KeyAlgorithm");
        Object trileadSupport = TrileadVersionSupportManagerTest.invokeGetTrileadSupport(classloader);
        Assertions.assertEquals((Object)"hudson.plugins.sshslaves.verifiers.TrileadVersionSupportManager$LegacyTrileadVersionSupport", (Object)trileadSupport.getClass().getName());
    }

    @Test
    void testCurrentInstance() {
        Assertions.assertEquals(JenkinsTrilead9VersionSupport.class, TrileadVersionSupportManager.getTrileadSupport().getClass());
    }

    @Test
    void testCurrentInstanceWithIsolatedClassLoader() {
        BlockingClassloader classloader = TrileadVersionSupportManagerTest.newBlockingClassloader();
        Object trileadSupport = TrileadVersionSupportManagerTest.invokeGetTrileadSupport(classloader);
        Assertions.assertEquals((Object)"hudson.plugins.sshslaves.verifiers.JenkinsTrilead9VersionSupport", (Object)trileadSupport.getClass().getName());
        Assertions.assertNotEquals(JenkinsTrilead9VersionSupport.class, trileadSupport.getClass());
    }

    private static Object invokeGetTrileadSupport(ClassLoader classloader) {
        try {
            Class<?> clz = Class.forName("hudson.plugins.sshslaves.verifiers.TrileadVersionSupportManager", true, classloader);
            Method method = clz.getDeclaredMethod("getTrileadSupport", new Class[0]);
            method.setAccessible(true);
            return method.invoke(null, new Object[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static BlockingClassloader newBlockingClassloader() {
        BlockingClassloader classloader = new BlockingClassloader(TrileadVersionSupportManagerTest.class.getClassLoader());
        classloader.inspectPackage("hudson.plugins.sshslaves");
        return classloader;
    }

    private static class BlockingClassloader
    extends URLClassLoader {
        private final ClassLoader parent;
        private final Set<String> blockingClasses = new HashSet<String>();

        public BlockingClassloader(ClassLoader parent) {
            super(new URL[0], parent);
            this.parent = parent;
        }

        @Override
        public Class<?> loadClass(String className) throws ClassNotFoundException {
            if (this.blockingClasses.contains(className)) {
                throw new ClassNotFoundException(className);
            }
            try {
                return super.findClass(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.loadClass(className);
            }
        }

        public void inspectClass(String clz) {
            URL[] urls;
            for (URL url : urls = BlockingClassloader.getResourceURLs(this.parent, clz, true)) {
                super.addURL(url);
            }
        }

        public void inspectPackage(String pkg) {
            URL[] urls;
            for (URL url : urls = BlockingClassloader.getResourceURLs(this.parent, pkg, false)) {
                super.addURL(url);
            }
        }

        public void block(String clazz) {
            this.blockingClasses.add(clazz);
        }

        public void unBlock(String clazz) {
            this.blockingClasses.remove(clazz);
        }

        private static URL[] getResourceURLs(ClassLoader classLoader, String inspect, boolean isClass) {
            String res = inspect.replace('.', '/');
            if (isClass) {
                res = res.concat(".class");
            }
            ArrayList<URL> list = new ArrayList<URL>();
            try {
                Enumeration<URL> enumeration = classLoader.getResources(res);
                while (enumeration.hasMoreElements()) {
                    String url = enumeration.nextElement().toString();
                    if (url.endsWith(res)) {
                        url = url.substring(0, url.length() - res.length());
                    }
                    list.add(new URL(url));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return list.toArray(new URL[0]);
        }
    }
}

