/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.sshslaves;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.HostnamePortSpecification;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.model.Descriptor;
import hudson.model.Fingerprint;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.KnownHostsFileKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DumbSlave;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNull;
import org.htmlunit.html.HtmlPage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.junit.jupiter.WithJenkins;

@WithJenkins
class SSHLauncherTest {
    @TempDir
    private File temporaryFolder;
    private JenkinsRule j;

    SSHLauncherTest() {
    }

    @BeforeEach
    void setUp(JenkinsRule rule) {
        this.j = rule;
    }

    private void checkRoundTrip(String host) throws Exception {
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, "dummyCredentialId", null, "user", "pass")));
        SSHLauncher launcher = new SSHLauncher(host, 123, "dummyCredentialId");
        launcher.setSshHostKeyVerificationStrategy((SshHostKeyVerificationStrategy)new KnownHostsFileKeyVerificationStrategy());
        Assertions.assertEquals((Object)host.trim(), (Object)launcher.getHost());
        DumbSlave agent = new DumbSlave("agent", SSHLauncherTest.newFolder(this.temporaryFolder, "junit").getAbsolutePath(), (ComputerLauncher)launcher);
        this.j.jenkins.addNode((Node)agent);
        HtmlPage p = this.j.createWebClient().getPage((Node)agent, "configure");
        this.j.submit(p.getFormByName("config"));
        Slave n = (Slave)this.j.jenkins.getNode("agent");
        Assertions.assertNotSame((Object)n, (Object)agent);
        Assertions.assertNotSame((Object)n.getLauncher(), (Object)launcher);
        this.j.assertEqualDataBoundBeans((Object)n.getLauncher(), (Object)launcher);
    }

    @Test
    void configurationRoundTrip() throws Exception {
        this.checkRoundTrip("localhost");
    }

    @Test
    void fillCredentials() {
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(new Domain("test", null, Collections.singletonList(new HostnamePortSpecification(null, null))), Collections.singletonList(new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, "dummyCredentialId", "john", null, null, null)));
        SSHLauncher.DescriptorImpl desc = (SSHLauncher.DescriptorImpl)this.j.jenkins.getDescriptorOrDie(SSHLauncher.class);
        Assertions.assertEquals((int)2, (int)desc.doFillCredentialsIdItems((AccessControlled)this.j.jenkins, "", "22", "does-not-exist").size());
        Assertions.assertEquals((int)1, (int)desc.doFillCredentialsIdItems((AccessControlled)this.j.jenkins, "", "22", "dummyCredentialId").size());
        Assertions.assertEquals((int)1, (int)desc.doFillCredentialsIdItems((AccessControlled)this.j.jenkins, "", "forty two", "does-not-exist").size());
        Assertions.assertEquals((int)1, (int)desc.doFillCredentialsIdItems((AccessControlled)this.j.jenkins, "", "", "does-not-exist").size());
    }

    @Test
    void checkJavaPathWhiteSpaces() {
        SSHLauncher.DescriptorImpl desc = (SSHLauncher.DescriptorImpl)this.j.jenkins.getDescriptorOrDie(SSHLauncher.class);
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckJavaPath("/usr/lib/jdk/bin/java"));
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckJavaPath("\"/usr/lib/jdk/bin/java\""));
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckJavaPath("'/usr/lib/jdk/bin/java'"));
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckJavaPath("\"/usr/lib/jdk 11/bin/java\""));
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckJavaPath("'/usr/lib/jdk 11/bin/java'"));
        Assertions.assertEquals((Object)FormValidation.Kind.WARNING, (Object)desc.doCheckJavaPath((String)"/usr/lib/jdk 11/bin/java").kind);
    }

    @Test
    void checkHost() {
        SSHLauncher.DescriptorImpl desc = (SSHLauncher.DescriptorImpl)this.j.jenkins.getDescriptorOrDie(SSHLauncher.class);
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckHost("hostname"));
        Assertions.assertEquals((Object)FormValidation.Kind.ERROR, (Object)desc.doCheckHost((String)"").kind);
        Assertions.assertEquals((Object)FormValidation.Kind.ERROR, (Object)desc.doCheckHost(null).kind);
    }

    @Test
    void checkPort() {
        SSHLauncher.DescriptorImpl desc = (SSHLauncher.DescriptorImpl)this.j.jenkins.getDescriptorOrDie(SSHLauncher.class);
        Assertions.assertEquals((Object)FormValidation.ok(), (Object)desc.doCheckPort("22"));
        Assertions.assertEquals((Object)FormValidation.Kind.ERROR, (Object)desc.doCheckPort((String)"").kind);
        Assertions.assertEquals((Object)FormValidation.Kind.ERROR, (Object)desc.doCheckPort(null).kind);
        Assertions.assertEquals((Object)FormValidation.Kind.ERROR, (Object)desc.doCheckPort((String)"-1").kind);
        Assertions.assertEquals((Object)FormValidation.Kind.ERROR, (Object)desc.doCheckPort((String)"65536").kind);
    }

    @Test
    void trimWhiteSpace() throws Exception {
        this.checkRoundTrip("   localhost");
        this.checkRoundTrip("localhost    ");
        this.checkRoundTrip("   localhost    ");
    }

    @Test
    void trackCredentialsWithUsernameAndPassword() throws Exception {
        UsernamePasswordCredentialsImpl credentials = new UsernamePasswordCredentialsImpl(CredentialsScope.SYSTEM, "dummyCredentialId", null, "user", "pass");
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(credentials));
        SSHLauncher launcher = new SSHLauncher("localhost", 123, "dummyCredentialId");
        launcher.setLaunchTimeoutSeconds(Integer.valueOf(5));
        launcher.setRetryWaitTime(Integer.valueOf(5));
        launcher.setMaxNumRetries(Integer.valueOf(2));
        DumbSlave agent = new DumbSlave("agent", SSHLauncherTest.newFolder(this.temporaryFolder, "junit").getAbsolutePath(), (ComputerLauncher)launcher);
        Fingerprint fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credentials);
        MatcherAssert.assertThat((String)"No fingerprint created until use", (Object)fingerprint, (Matcher)IsNull.nullValue());
        this.j.jenkins.addNode((Node)agent);
        while (agent.toComputer().isConnecting()) {
            Thread.sleep(100L);
        }
        fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credentials);
        MatcherAssert.assertThat((Object)fingerprint, (Matcher)IsNull.notNullValue());
    }

    @Test
    void trackCredentialsWithUsernameAndPrivateKey() throws Exception {
        BasicSSHUserPrivateKey credentials = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, "dummyCredentialId", "user", null, "", "desc");
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(credentials));
        SSHLauncher launcher = new SSHLauncher("localhost", 123, "dummyCredentialId");
        launcher.setLaunchTimeoutSeconds(Integer.valueOf(5));
        launcher.setRetryWaitTime(Integer.valueOf(5));
        launcher.setMaxNumRetries(Integer.valueOf(2));
        DumbSlave agent = new DumbSlave("agent", SSHLauncherTest.newFolder(this.temporaryFolder, "junit").getAbsolutePath(), (ComputerLauncher)launcher);
        Fingerprint fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credentials);
        MatcherAssert.assertThat((String)"No fingerprint created until use", (Object)fingerprint, (Matcher)IsNull.nullValue());
        this.j.jenkins.addNode((Node)agent);
        while (agent.toComputer().isConnecting()) {
            Thread.sleep(100L);
        }
        fingerprint = CredentialsProvider.getFingerprintOf((Credentials)credentials);
        MatcherAssert.assertThat((Object)fingerprint, (Matcher)IsNull.notNullValue());
    }

    @Test
    void workDirTest() {
        String rootFS = "/home/user";
        String anotherWorkDir = "/another/workdir";
        SSHLauncher launcher = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix", Integer.valueOf(60), Integer.valueOf(10), Integer.valueOf(15), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        Assertions.assertEquals((Object)(" -workDir " + rootFS + " -jar-cache " + rootFS + "/remoting/jarCache"), (Object)launcher.getWorkDirParam(rootFS));
        launcher = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix -workDir " + anotherWorkDir, Integer.valueOf(60), Integer.valueOf(10), Integer.valueOf(15), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        Assertions.assertEquals((Object)"", (Object)launcher.getWorkDirParam(rootFS));
        launcher.setWorkDir(anotherWorkDir);
        Assertions.assertEquals((Object)"", (Object)launcher.getWorkDirParam(rootFS));
        launcher = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix", Integer.valueOf(60), Integer.valueOf(10), Integer.valueOf(15), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        launcher.setWorkDir(anotherWorkDir);
        Assertions.assertEquals((Object)(" -workDir " + anotherWorkDir + " -jar-cache " + anotherWorkDir + "/remoting/jarCache"), (Object)launcher.getWorkDirParam(rootFS));
    }

    @Test
    void timeoutAndRetrySettings() {
        SSHLauncher launcher = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix", Integer.valueOf(39), Integer.valueOf(18), Integer.valueOf(25), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        Assertions.assertEquals((int)39, (int)launcher.getLaunchTimeoutSeconds());
        Assertions.assertEquals((int)18, (int)launcher.getMaxNumRetries());
        Assertions.assertEquals((int)25, (int)launcher.getRetryWaitTime());
    }

    @Test
    void timeoutAndRetrySettingsAllowZero() {
        SSHLauncher launcher = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix", Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(0), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        Assertions.assertEquals((int)0, (int)launcher.getMaxNumRetries());
        Assertions.assertEquals((int)0, (int)launcher.getRetryWaitTime());
    }

    @Test
    void timeoutAndRetrySettingsSetDefaultsIfOutOfRange() {
        SSHLauncher launcher = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix", Integer.valueOf(0), Integer.valueOf(-1), Integer.valueOf(-1), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        Assertions.assertEquals((Integer)SSHLauncher.DEFAULT_LAUNCH_TIMEOUT_SECONDS, (Integer)launcher.getLaunchTimeoutSeconds());
        Assertions.assertEquals((Integer)SSHLauncher.DEFAULT_MAX_NUM_RETRIES, (Integer)launcher.getMaxNumRetries());
        Assertions.assertEquals((Integer)SSHLauncher.DEFAULT_RETRY_WAIT_TIME, (Integer)launcher.getRetryWaitTime());
        SSHLauncher launcher2 = new SSHLauncher("Hostname", 22, "credentialID", "jvmOptions", "javaPath", "prefix", "suffix", null, null, null, (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        Assertions.assertEquals((Integer)SSHLauncher.DEFAULT_LAUNCH_TIMEOUT_SECONDS, (Integer)launcher2.getLaunchTimeoutSeconds());
        Assertions.assertEquals((Integer)SSHLauncher.DEFAULT_MAX_NUM_RETRIES, (Integer)launcher2.getMaxNumRetries());
        Assertions.assertEquals((Integer)SSHLauncher.DEFAULT_RETRY_WAIT_TIME, (Integer)launcher2.getRetryWaitTime());
    }

    @Test
    void getMd5Hash() throws Exception {
        byte[] bytes = "Leave me alone!".getBytes();
        String result = SSHLauncher.getMd5Hash((byte[])bytes);
        Assertions.assertEquals((Object)"1EB226C8E950BAC1494BE197E84A264C", (Object)result);
    }

    @Test
    void readInputStreamIntoByteArrayAndClose() throws Exception {
        File testFile = new File("target" + File.separator + "test-classes", "readInputStreamIntoByteArrayTestFile.txt");
        try (FileInputStream inputStream = new FileInputStream(testFile);){
            Assertions.assertTrue((boolean)testFile.exists());
            byte[] bytes = SSHLauncher.readInputStreamIntoByteArrayAndClose((InputStream)inputStream);
            Assertions.assertNotNull((Object)bytes);
            Assertions.assertTrue((bytes.length > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((Object)"Don't change me or add newlines!", (Object)new String(bytes));
        }
    }

    @Test
    void retryTest() throws IOException, InterruptedException, Descriptor.FormException {
        DumbSlave agent = this.getPermanentAgentHostNotExist();
        this.j.jenkins.addNode((Node)agent);
        String log = "";
        for (int i = 0; i < 60; ++i) {
            Thread.sleep(1000L);
            log = agent.getComputer().getLog();
            if (log.contains("There are 1 more retries left.")) break;
        }
        Assertions.assertTrue((boolean)log.contains("There are 3 more retries left."));
        Assertions.assertTrue((boolean)log.contains("There are 2 more retries left."));
        Assertions.assertTrue((boolean)log.contains("There are 1 more retries left."));
        Assertions.assertFalse((boolean)log.contains("There are 4 more retries left."));
    }

    @Test
    void knownHostsFileDefaultConfig() {
        String defaultPath = Paths.get(System.getProperty("user.home"), ".ssh", "known_hosts").toString();
        KnownHostsFileKeyVerificationStrategy khvs = new KnownHostsFileKeyVerificationStrategy();
        Assertions.assertEquals((Object)khvs.getKnownHostsFile().getPath(), (Object)defaultPath);
    }

    private DumbSlave getPermanentAgentHostNotExist() throws Descriptor.FormException, IOException {
        this.fakeCredentials("dummyCredentialId");
        SSHLauncher launcher = new SSHLauncher("HostNotExists", 22, "dummyCredentialId");
        launcher.setSshHostKeyVerificationStrategy((SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        launcher.setLaunchTimeoutSeconds(Integer.valueOf(5));
        launcher.setRetryWaitTime(Integer.valueOf(1));
        launcher.setMaxNumRetries(Integer.valueOf(3));
        return new DumbSlave("agent", SSHLauncherTest.newFolder(this.temporaryFolder, "junit").getAbsolutePath(), (ComputerLauncher)launcher);
    }

    private void fakeCredentials(String id) {
        BasicSSHUserPrivateKey credentials = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, id, "user", null, "", "desc");
        SystemCredentialsProvider.getInstance().getDomainCredentialsMap().put(Domain.global(), Collections.singletonList(credentials));
    }

    private static File newFolder(File root, String ... subDirs) {
        String subFolder = String.join((CharSequence)"/", subDirs);
        File result = new File(root, subFolder);
        Assertions.assertFalse((!result.exists() && !result.mkdirs() ? 1 : 0) != 0, (String)("Couldn't create folders " + String.valueOf(result)));
        return result;
    }
}

