/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent;

import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentStepExecution;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class SSHAgentStep
extends Step {
    private final List<String> credentials;
    private boolean ignoreMissing;

    @DataBoundConstructor
    public SSHAgentStep(List<String> credentials) {
        this.credentials = credentials;
        this.ignoreMissing = false;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new SSHAgentStepExecution(this, context);
    }

    @DataBoundSetter
    public void setIgnoreMissing(boolean ignoreMissing) {
        this.ignoreMissing = ignoreMissing;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public List<String> getCredentials() {
        return this.credentials;
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "sshagent";
        }

        @NonNull
        public String getDisplayName() {
            return Messages.SSHAgentBuildWrapper_DisplayName();
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Launcher.class, TaskListener.class, Run.class, FilePath.class);
        }

        public ListBoxModel doFillCredentialsItems(@AncestorInPath Item item) {
            Jenkins contextToCheck;
            Object object = contextToCheck = item == null ? Jenkins.get() : item;
            if (!contextToCheck.hasPermission(CredentialsProvider.VIEW)) {
                return new StandardUsernameListBoxModel();
            }
            return new StandardUsernameListBoxModel().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2, item, SSHUserPrivateKey.class, Collections.emptyList(), SSHAuthenticator.matcher());
        }
    }
}

