/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent;

import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.exec.ExecRemoteAgent;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Environment;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;

public class SSHAgentBuildWrapper
extends BuildWrapper {
    private transient String user;
    private final List<String> credentialIds;
    private final boolean ignoreMissing;

    @Deprecated
    public SSHAgentBuildWrapper(String user) {
        this(Collections.singletonList(user), false);
    }

    @DataBoundConstructor
    public SSHAgentBuildWrapper(CredentialHolder[] credentialHolders, boolean ignoreMissing) {
        this(CredentialHolder.toIdList(credentialHolders), ignoreMissing);
    }

    public SSHAgentBuildWrapper(List<String> credentialIds, boolean ignoreMissing) {
        this.credentialIds = new ArrayList<String>(new LinkedHashSet<String>(credentialIds));
        this.ignoreMissing = ignoreMissing;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.user != null) {
            return new SSHAgentBuildWrapper(Collections.singletonList(this.user), false);
        }
        return this;
    }

    @Deprecated
    public String getUser() {
        return this.credentialIds.isEmpty() ? null : this.credentialIds.get(0);
    }

    public List<String> getCredentialIds() {
        return Collections.unmodifiableList(this.credentialIds);
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public CredentialHolder[] getCredentialHolders() {
        ArrayList<CredentialHolder> result = new ArrayList<CredentialHolder>(this.credentialIds.size());
        for (String id : this.credentialIds) {
            result.add(new CredentialHolder(id));
        }
        return result.toArray(new CredentialHolder[0]);
    }

    public void preCheckout(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        ArrayList<SSHUserPrivateKey> keys = new ArrayList<SSHUserPrivateKey>();
        for (String id : new LinkedHashSet<String>(this.getCredentialIds())) {
            SSHUserPrivateKey c = (SSHUserPrivateKey)CredentialsProvider.findCredentialById((String)id, SSHUserPrivateKey.class, (Run)build);
            CredentialsProvider.track((Run)build, (Credentials)c);
            if (c == null && !this.ignoreMissing) {
                IOException ioe = new IOException(Messages.SSHAgentBuildWrapper_CredentialsNotFound(id));
                ioe.printStackTrace(listener.fatalError(""));
                throw ioe;
            }
            if (c == null || keys.contains(c)) continue;
            keys.add(c);
        }
        SSHAgentEnvironment environment = null;
        for (Environment env : build.getEnvironments()) {
            if (!(env instanceof SSHAgentEnvironment)) continue;
            environment = (SSHAgentEnvironment)env;
        }
        if (environment == null) {
            environment = this.createSSHAgentEnvironment(build, launcher, listener);
            build.getEnvironments().add((Object)environment);
        }
        for (SSHUserPrivateKey key : keys) {
            environment.add(key);
            listener.getLogger().println(Messages.SSHAgentBuildWrapper_UsingCredentials(SSHAgentBuildWrapper.description((StandardUsernameCredentials)key)));
        }
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        return new NoOpEnvironment();
    }

    private SSHAgentEnvironment createSSHAgentEnvironment(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        try {
            return new SSHAgentEnvironment(launcher, listener, build.getWorkspace());
        }
        catch (InterruptedException e) {
            e.printStackTrace(listener.fatalError(Messages.SSHAgentBuildWrapper_CouldNotStartAgent()));
            throw e;
        }
        catch (Throwable e) {
            throw new IOException(Messages.SSHAgentBuildWrapper_CouldNotStartAgent(), e);
        }
    }

    @NonNull
    public static String description(@NonNull StandardUsernameCredentials c) {
        String description = Util.fixEmptyAndTrim((String)c.getDescription());
        return c.getUsername() + (String)(description != null ? " (" + description + ")" : "");
    }

    public static class CredentialHolder
    extends AbstractDescribableImpl<CredentialHolder> {
        private final String id;

        @DataBoundConstructor
        public CredentialHolder(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @NonNull
        public static List<String> toIdList(@Nullable CredentialHolder[] credentialHolders) {
            ArrayList<String> result = new ArrayList<String>(credentialHolders == null ? 0 : credentialHolders.length);
            if (credentialHolders != null) {
                for (CredentialHolder h : credentialHolders) {
                    result.add(h.getId());
                }
            }
            return result;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CredentialHolder> {
            @NonNull
            public String getDisplayName() {
                return Messages.SSHAgentBuildWrapper_CredentialHolder_DisplayName();
            }

            public ListBoxModel doFillIdItems(@AncestorInPath Item item) {
                Jenkins contextToCheck;
                Object object = contextToCheck = item == null ? Jenkins.get() : item;
                if (!contextToCheck.hasPermission(CredentialsProvider.VIEW)) {
                    return new StandardUsernameListBoxModel();
                }
                return new StandardUsernameListBoxModel().includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf2((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM2, item, SSHUserPrivateKey.class, Collections.emptyList(), SSHAuthenticator.matcher());
            }
        }
    }

    private class SSHAgentEnvironment
    extends BuildWrapper.Environment {
        private final ExecRemoteAgent agent;
        private final Launcher launcher;
        private final FilePath workspace;
        private final BuildListener listener;

        SSHAgentEnvironment(Launcher launcher, BuildListener listener, FilePath workspace) throws Throwable {
            super((BuildWrapper)SSHAgentBuildWrapper.this);
            this.launcher = launcher;
            this.workspace = Objects.requireNonNull(workspace);
            this.listener = listener;
            listener.getLogger().println("[ssh-agent] Looking for ssh-agent implementation...");
            this.agent = new ExecRemoteAgent(launcher, (TaskListener)listener);
            listener.getLogger().println(Messages.SSHAgentBuildWrapper_Started());
        }

        public void add(SSHUserPrivateKey key) throws IOException, InterruptedException {
            Secret passphrase = key.getPassphrase();
            String effectivePassphrase = passphrase == null ? null : passphrase.getPlainText();
            for (String privateKey : key.getPrivateKeys()) {
                this.agent.addIdentity(privateKey, effectivePassphrase, SSHAgentBuildWrapper.description((StandardUsernameCredentials)key), this.workspace, this.launcher, (TaskListener)this.listener);
            }
        }

        public void buildEnvVars(Map<String, String> env) {
            env.putAll(this.agent.getEnv());
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            if (this.agent != null) {
                this.agent.stop(this.launcher, (TaskListener)listener);
                listener.getLogger().println(Messages.SSHAgentBuildWrapper_Stopped());
            }
            return true;
        }
    }

    private class NoOpEnvironment
    extends BuildWrapper.Environment {
        private NoOpEnvironment() {
            super((BuildWrapper)SSHAgentBuildWrapper.this);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.SSHAgentBuildWrapper_DisplayName();
        }
    }
}

