/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent.exec;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.slaves.WorkspaceList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class ExecRemoteAgent
implements Serializable {
    private static final String AuthSocketVar = "SSH_AUTH_SOCK";
    private static final String AgentPidVar = "SSH_AGENT_PID";
    private final Map<String, String> agentEnv;

    public ExecRemoteAgent(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (launcher.launch().cmds(new String[]{"ssh-agent"}).stdout((OutputStream)baos).start().joinWithTimeout(1L, TimeUnit.MINUTES, listener) != 0) {
            String reason = new String(baos.toByteArray(), StandardCharsets.US_ASCII);
            throw new AbortException("Failed to run ssh-agent: " + reason);
        }
        this.agentEnv = this.parseAgentEnv(new String(baos.toByteArray(), StandardCharsets.US_ASCII), listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdentity(String privateKey, String passphrase, String comment, FilePath ws, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        FilePath temp = WorkspaceList.tempDir((FilePath)ws);
        if (temp == null) {
            throw new IOException("No temp dir in " + String.valueOf(ws));
        }
        FilePath keyFile = temp.createTextTempFile("private_key_", ".key", privateKey);
        try {
            keyFile.chmod(384);
            FilePath askpass = passphrase != null ? this.createAskpassScript(temp) : null;
            try {
                HashMap<String, String> env = new HashMap<String, String>(this.agentEnv);
                if (passphrase != null) {
                    env.put("SSH_PASSPHRASE", passphrase);
                    env.put("DISPLAY", "bogus");
                    env.put("SSH_ASKPASS", askpass.getRemote());
                }
                listener.getLogger().println("Running ssh-add (command line suppressed)");
                if (launcher.launch().quiet(true).cmds(new String[]{"ssh-add", keyFile.getRemote()}).envs(env).stdout(listener).start().joinWithTimeout(1L, TimeUnit.MINUTES, listener) != 0) {
                    throw new AbortException("Failed to run ssh-add");
                }
            }
            finally {
                if (askpass != null && askpass.exists()) {
                    askpass.delete();
                }
            }
        }
        finally {
            keyFile.delete();
        }
    }

    public Map<String, String> getEnv() {
        return this.agentEnv;
    }

    public void stop(Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        if (launcher.launch().cmds(new String[]{"ssh-agent", "-k"}).envs(this.agentEnv).stdout(listener).start().joinWithTimeout(1L, TimeUnit.MINUTES, listener) != 0) {
            throw new AbortException("Failed to run ssh-agent -k");
        }
    }

    private Map<String, String> parseAgentEnv(String agentOutput, TaskListener listener) throws IOException, InterruptedException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(AuthSocketVar, this.getAgentValue(agentOutput, AuthSocketVar));
        listener.getLogger().println("SSH_AUTH_SOCK=" + (String)env.get(AuthSocketVar));
        env.put(AgentPidVar, this.getAgentValue(agentOutput, AgentPidVar));
        listener.getLogger().println("SSH_AGENT_PID=" + (String)env.get(AgentPidVar));
        return env;
    }

    private String getAgentValue(String agentOutput, String envVar) {
        int pos = agentOutput.indexOf(envVar) + envVar.length() + 1;
        int end = agentOutput.indexOf(59, pos);
        return agentOutput.substring(pos, end);
    }

    private FilePath createAskpassScript(FilePath temp) throws IOException, InterruptedException {
        FilePath askpass = temp.createTextTempFile("askpass_", ".sh", "#!/bin/sh\necho \"$SSH_PASSPHRASE\"\nrm \"$0\"\n");
        askpass.chmod(448);
        return askpass;
    }
}

