/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.sshagent;

import com.cloudbees.jenkins.plugins.sshagent.Messages;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentBuildWrapper;
import com.cloudbees.jenkins.plugins.sshagent.SSHAgentStep;
import com.cloudbees.jenkins.plugins.sshagent.exec.ExecRemoteAgent;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;

final class SSHAgentStepExecution
extends AbstractStepExecutionImpl {
    private static final long serialVersionUID = 1L;
    private transient SSHAgentStep step;
    private ExecRemoteAgent agent;

    SSHAgentStepExecution(SSHAgentStep step, StepContext context) {
        super(context);
        this.step = step;
    }

    public boolean start() throws Exception {
        StepContext context = this.getContext();
        this.initRemoteAgent();
        context.newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(this))).withCallback((BodyExecutionCallback)new Callback(this)).start();
        return false;
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        try {
            this.stop();
        }
        catch (Exception x) {
            cause.addSuppressed(x);
        }
        super.stop(cause);
    }

    private void stop() throws Exception {
        if (this.agent != null) {
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            if (listener != null && launcher != null) {
                this.agent.stop(launcher, listener);
                listener.getLogger().println(Messages.SSHAgentBuildWrapper_Stopped());
            }
        }
    }

    private void initRemoteAgent() throws IOException, InterruptedException {
        Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        Run build = (Run)this.getContext().get(Run.class);
        FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
        ArrayList<SSHUserPrivateKey> userPrivateKeys = new ArrayList<SSHUserPrivateKey>();
        for (String id : new LinkedHashSet<String>(this.step.getCredentials())) {
            SSHUserPrivateKey c = (SSHUserPrivateKey)CredentialsProvider.findCredentialById((String)id, SSHUserPrivateKey.class, (Run)build);
            CredentialsProvider.track((Run)build, (Credentials)c);
            if (c == null && !this.step.isIgnoreMissing()) {
                throw new AbortException(Messages.SSHAgentBuildWrapper_CredentialsNotFound(id));
            }
            if (c == null || userPrivateKeys.contains(c)) continue;
            userPrivateKeys.add(c);
        }
        for (SSHUserPrivateKey userPrivateKey : userPrivateKeys) {
            listener.getLogger().println(Messages.SSHAgentBuildWrapper_UsingCredentials(SSHAgentBuildWrapper.description((StandardUsernameCredentials)userPrivateKey)));
        }
        this.agent = new ExecRemoteAgent(launcher, listener);
        for (SSHUserPrivateKey userPrivateKey : userPrivateKeys) {
            Secret passphrase = userPrivateKey.getPassphrase();
            String effectivePassphrase = passphrase == null ? null : passphrase.getPlainText();
            for (String privateKey : userPrivateKey.getPrivateKeys()) {
                this.agent.addIdentity(privateKey, effectivePassphrase, SSHAgentBuildWrapper.description((StandardUsernameCredentials)userPrivateKey), workspace, launcher, listener);
            }
        }
        listener.getLogger().println(Messages.SSHAgentBuildWrapper_Started());
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final SSHAgentStepExecution execution;

        ExpanderImpl(SSHAgentStepExecution execution) {
            this.execution = execution;
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideAll(this.execution.agent.getEnv());
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final SSHAgentStepExecution execution;

        Callback(SSHAgentStepExecution execution) {
            this.execution = execution;
        }

        protected void finished(StepContext context) throws Exception {
            this.execution.stop();
        }
    }
}

