/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ssegateway.sse;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.security.csrf.CrumbIssuer;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ssegateway.Util;
import org.jenkinsci.plugins.ssegateway.sse.EventDispatcher;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Restricted(value={NoExternalUse.class})
public class EventDispatcherFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)EventDispatcherFactory.class.getName());
    public static final String DISPATCHER_SESSION_KEY = EventDispatcher.class.getName();
    private static Class<? extends EventDispatcher> runtimeClass;

    public static EventDispatcher start(@NonNull String clientId, @NonNull HttpServletRequest request, @NonNull HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            EventDispatcher dispatcher = EventDispatcherFactory.getDispatcher(clientId, session);
            if (dispatcher == null) {
                LOGGER.debug(String.format("Unknown dispatcher client Id '%s' on HTTP session '%s'. Creating a new one. Make sure you are calling 'connect' before 'listen' and that HTTP sessions are being maintained between 'connect' and 'configure' calls. SSE client reconnects will not work - probably fine if running in non-browser/test mode.", clientId, session.getId()));
                dispatcher = EventDispatcherFactory.newDispatcher(clientId, session);
            }
            dispatcher.start(request, response);
            dispatcher.setDefaultHeaders();
            JSONObject openData = new JSONObject();
            openData.put("dispatcherId", (Object)dispatcher.getId());
            openData.put("dispatcherInst", (Object)System.identityHashCode(dispatcher));
            if (Util.isTestEnv()) {
                openData.putAll(Util.getSessionInfo(session));
                Jenkins jenkins = Jenkins.get();
                CrumbIssuer crumbIssuer = jenkins.getCrumbIssuer();
                if (crumbIssuer != null) {
                    JSONObject crumb = new JSONObject();
                    crumb.put("name", (Object)crumbIssuer.getDescriptor().getCrumbRequestField());
                    crumb.put("value", (Object)crumbIssuer.getCrumb((ServletRequest)request));
                    openData.put("crumb", (Object)crumb);
                } else {
                    LOGGER.warn("No CrumbIssuer on Jenkins instance. Some POSTs might not work.");
                }
            }
            dispatcher.dispatchEvent("open", openData.toString());
            dispatcher.processRetries();
            return dispatcher;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected Exception.", e);
        }
    }

    public static synchronized Map<String, EventDispatcher> getDispatchers(@NonNull HttpSession session) {
        HashMap dispatchers = (HashMap)session.getAttribute(DISPATCHER_SESSION_KEY);
        if (dispatchers == null) {
            dispatchers = new HashMap();
            session.setAttribute(DISPATCHER_SESSION_KEY, dispatchers);
        }
        return dispatchers;
    }

    public static synchronized EventDispatcher newDispatcher(@NonNull String clientId, @NonNull HttpSession session) {
        Map<String, EventDispatcher> dispatchers = EventDispatcherFactory.getDispatchers(session);
        try {
            EventDispatcher dispatcher = runtimeClass.newInstance();
            dispatcher.setId(clientId);
            dispatchers.put(clientId, dispatcher);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("New dispatcher '%s' attached to HTTP session '%s'.", dispatcher, session.getId()));
            }
            return dispatcher;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected Exception.", e);
        }
    }

    @CheckForNull
    public static EventDispatcher getDispatcher(@NonNull String dispatcherId, @NonNull HttpSession session) {
        Map<String, EventDispatcher> dispatchers = EventDispatcherFactory.getDispatchers(session);
        return dispatchers.get(dispatcherId);
    }

    private static boolean isAsyncSupported() {
        String asyncSupportedProp = System.getProperty("jenkins.eventbus.web.asyncSupported");
        if (asyncSupportedProp != null) {
            return asyncSupportedProp.equals("true");
        }
        try {
            HttpServletRequest.class.getMethod("startAsync", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    static {
        try {
            runtimeClass = EventDispatcherFactory.isAsyncSupported() ? Class.forName(EventDispatcherFactory.class.getPackage().getName() + ".AsynchEventDispatcher") : Class.forName(EventDispatcherFactory.class.getPackage().getName() + ".SynchEventDispatcher");
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unexpected Exception.", e);
        }
    }
}

