/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.model;

import com.hello2morrow.sonargraph.integration.jenkins.model.AbstractPlot;
import com.hello2morrow.sonargraph.integration.jenkins.model.IMetricHistoryProvider;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;

public class XYLineAndShapePlot
extends AbstractPlot {
    private static final String COLON = ": ";
    private static final String BUILD = "Build #";

    public XYLineAndShapePlot(IMetricHistoryProvider datasetProvider) {
        super(datasetProvider);
    }

    @Override
    protected JFreeChart createChartInternal(String chartTitle, String categoryName, String yAxisName, XYDataset dataset) {
        return ChartFactory.createXYLineChart((String)chartTitle, (String)categoryName, (String)yAxisName, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
    }

    @Override
    protected void applyRendering(XYPlot plot) {
        NumberAxis axis = (NumberAxis)plot.getDomainAxis();
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setSeriesPaint(0, DATA_COLOR);
        StandardXYToolTipGenerator toolTipGenerator = new StandardXYToolTipGenerator(){
            private static final long serialVersionUID = -5803780142385784897L;

            public String generateToolTip(XYDataset dataset, int series, int item) {
                return XYLineAndShapePlot.BUILD + dataset.getXValue(series, item) + XYLineAndShapePlot.COLON + dataset.getYValue(series, item);
            }
        };
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
    }
}

