/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.tool;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.kohsuke.stapler.DataBoundConstructor;

public class SonargraphBuild
extends ToolInstallation
implements NodeSpecific<SonargraphBuild>,
EnvironmentSpecific<SonargraphBuild> {
    private static final long serialVersionUID = 1L;

    public SonargraphBuild(String name, String home) {
        super(name, home, Collections.emptyList());
    }

    @DataBoundConstructor
    public SonargraphBuild(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    @NonNull
    public SonargraphBuild forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new SonargraphBuild(this.getName(), this.translateFor(node, log));
    }

    public SonargraphBuild forEnvironment(EnvVars environment) {
        return new SonargraphBuild(this.getName(), environment.expand(this.getHome()));
    }

    @Extension
    public static class DescriptorImpl
    extends ToolDescriptor<SonargraphBuild> {
        public DescriptorImpl() {
            this.load();
        }

        public List<? extends ToolInstaller> getDefaultInstallers() {
            return Collections.emptyList();
        }

        public void setInstallations(SonargraphBuild ... installations) {
            super.setInstallations((ToolInstallation[])installations);
            this.save();
        }

        public SonargraphBuild getSonargraphBuild(String name) {
            assert (name != null && !name.isEmpty()) : "Parameter 'name' of method 'getSonargraphBuild' must not be empty";
            for (SonargraphBuild sonargraphBuild : (SonargraphBuild[])this.getInstallations()) {
                if (!name.equals(sonargraphBuild.getName())) continue;
                return sonargraphBuild;
            }
            SonargraphLogger.INSTANCE.log(Level.WARNING, "Unknown Sonargraph Build: " + name);
            for (SonargraphBuild sonargraphBuild : (SonargraphBuild[])this.getInstallations()) {
                SonargraphLogger.INSTANCE.log(Level.WARNING, "Found Sonargraph Build: " + sonargraphBuild.getName());
            }
            return null;
        }

        protected FormValidation checkHomeDirectory(File home) {
            return super.checkHomeDirectory(home);
        }

        @NonNull
        public String getDisplayName() {
            return "Sonargraph Build";
        }
    }
}

