/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.persistence;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.io.PrintStream;
import java.util.logging.Level;

public final class ReportHistoryFileManager {
    private final FilePath m_sonargraphReportHistoryDir;
    private final String m_reportHistoryFileName;

    public ReportHistoryFileManager(FilePath projectRootDir, String reportHistoryBaseDirectoryName, String reportHistoryFileName, PrintStream logger) throws IOException, InterruptedException {
        assert (projectRootDir != null) : "The path to the folder where architect reports are stored must not be null";
        assert (!projectRootDir.isRemote()) : "The path to the folder where architect reports are stored must not be remote";
        assert (reportHistoryBaseDirectoryName != null && !reportHistoryBaseDirectoryName.isEmpty()) : "reportHistoryBaseDirectoryName must not be empty";
        assert (reportHistoryFileName != null && !reportHistoryFileName.isEmpty()) : "reportHistoryFileName must not be empty";
        assert (logger != null) : "Parameter 'logger' of method 'ReportHistoryFileManager' must not be null";
        this.m_reportHistoryFileName = reportHistoryFileName;
        this.m_sonargraphReportHistoryDir = new FilePath(projectRootDir, reportHistoryBaseDirectoryName);
        if (!this.m_sonargraphReportHistoryDir.exists()) {
            try {
                this.m_sonargraphReportHistoryDir.mkdirs();
            }
            catch (IOException ex) {
                SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, "Failed to create directory '" + this.m_sonargraphReportHistoryDir.getRemote() + "'", ex);
            }
        }
    }

    public FilePath getReportHistoryDirectory() {
        return this.m_sonargraphReportHistoryDir;
    }

    public FilePath storeGeneratedReportDirectory(FilePath reportDirectory, String reportName, Integer buildNumber, PrintStream logger) throws IOException, InterruptedException {
        assert (reportDirectory != null) : "Parameter 'reportDirectory' of method 'soterdGeneratedReportDirectory' must not be null";
        assert (reportDirectory.exists()) : "Parameter 'reportDirectory' must be an existing folder. '" + reportDirectory.getRemote() + "' does not exist.";
        if (!this.m_sonargraphReportHistoryDir.exists()) {
            String msg = "Unable to create directory " + this.m_sonargraphReportHistoryDir.getRemote();
            SonargraphLogger.logToConsoleOutput(logger, Level.SEVERE, msg, null);
            throw new IOException(msg);
        }
        FilePath targetHistoryDirectory = new FilePath(this.m_sonargraphReportHistoryDir, "sonargraph-report-build-" + buildNumber);
        reportDirectory.copyRecursiveTo("**/*.*", "*.html,*.xml", targetHistoryDirectory);
        SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Copied report related files to directory " + targetHistoryDirectory.getRemote(), null);
        FilePath targetXmlReportFile = null;
        FilePath sourceXmlReportFile = new FilePath(reportDirectory, reportName + ".xml");
        if (sourceXmlReportFile.exists()) {
            targetXmlReportFile = new FilePath(targetHistoryDirectory, this.m_reportHistoryFileName + ".xml");
            sourceXmlReportFile.copyTo(targetXmlReportFile);
            SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Copied xml report file from " + sourceXmlReportFile.getRemote() + " to " + targetXmlReportFile.getRemote(), null);
        } else {
            SonargraphLogger.logToConsoleOutput(logger, Level.WARNING, "No xml report file found at " + sourceXmlReportFile.getRemote(), null);
        }
        FilePath sourceHtmlReportFile = new FilePath(reportDirectory, reportName + ".html");
        if (sourceHtmlReportFile.exists()) {
            FilePath targetHtmlReportFile = new FilePath(targetHistoryDirectory, this.m_reportHistoryFileName + ".html");
            sourceHtmlReportFile.copyTo(targetHtmlReportFile);
            SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Copied html report file from " + sourceHtmlReportFile.getRemote() + " to " + targetHtmlReportFile.getRemote(), null);
        } else {
            SonargraphLogger.logToConsoleOutput(logger, Level.WARNING, "No html report file found at " + sourceHtmlReportFile.getRemote(), null);
        }
        FilePath sourceHtmlDiffReportFile = new FilePath(reportDirectory, reportName + "_diff.html");
        if (sourceHtmlDiffReportFile.exists()) {
            FilePath targetHtmlDiffReportFile = new FilePath(targetHistoryDirectory, this.m_reportHistoryFileName + "_diff.html");
            sourceHtmlDiffReportFile.copyTo(targetHtmlDiffReportFile);
            SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Copied html diff report file from " + sourceHtmlDiffReportFile.getRemote() + " to " + targetHtmlDiffReportFile.getRemote(), null);
        } else {
            SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "No html diff report file found at " + sourceHtmlDiffReportFile.getRemote(), null);
        }
        FilePath latest = new FilePath(this.m_sonargraphReportHistoryDir, "latest");
        latest.symlinkTo(targetHistoryDirectory.getName(), (TaskListener)new LogTaskListener(SonargraphLogger.INSTANCE, Level.INFO));
        SonargraphLogger.logToConsoleOutput(logger, Level.INFO, "Created symlink 'latest' to " + targetHistoryDirectory.getRemote(), null);
        return targetXmlReportFile;
    }
}

