/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.controller.ConfigParameters;
import com.hello2morrow.sonargraph.integration.jenkins.controller.Plotter;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.MetricIds;
import hudson.model.Job;
import hudson.model.ProminentProjectAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.model.JenkinsLocationConfiguration;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public class SonargraphIntegrationAction
implements ProminentProjectAction {
    private final Job<?, ?> job;
    private final MetricIds metaData;
    private final List<String> selectedMetrics;

    public SonargraphIntegrationAction(Job<?, ?> job, List<String> selectedMetrics, MetricIds metricMetaData) {
        this.job = job;
        this.metaData = metricMetaData;
        this.selectedMetrics = selectedMetrics;
    }

    public Collection<String> getChartsForMetrics() {
        ArrayList<String> chartsForMetrics = new ArrayList<String>();
        for (String metric : this.selectedMetrics) {
            chartsForMetrics.add(metric);
        }
        return chartsForMetrics;
    }

    public void doGetPlot(StaplerRequest2 req, StaplerResponse2 rsp) {
        Plotter.doGetPlot(this.job, this.metaData, req, rsp);
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getIconFileName() {
        return ConfigParameters.SONARGRAPH_ICON.getValue();
    }

    public String getDisplayName() {
        return ConfigParameters.ACTION_DISPLAY_INTEGRATION.getValue();
    }

    public String getUrlName() {
        return ConfigParameters.ACTION_URL_INTEGRATION.getValue();
    }

    public String getReportURL() {
        return this.getURL(ConfigParameters.ACTION_URL_REPORT);
    }

    public String getDiffURL() {
        return this.getURL(ConfigParameters.ACTION_URL_DIFF);
    }

    private String getURL(ConfigParameters lastPart) {
        JenkinsLocationConfiguration globalConfig = JenkinsLocationConfiguration.get();
        String url = globalConfig.getUrl();
        String projectName = this.job.getFullName();
        if (url != null) {
            return url + ConfigParameters.JOB_FOLDER.getValue() + projectName + "/" + lastPart.getValue();
        }
        return "../" + lastPart.getValue();
    }
}

