/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.integration.jenkins.controller;

import com.hello2morrow.sonargraph.integration.jenkins.foundation.SonargraphLogger;
import com.hello2morrow.sonargraph.integration.jenkins.persistence.TextFileReader;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.DirectoryBrowserSupport;
import hudson.model.ModelObject;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.logging.Level;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class AbstractHTMLAction
implements Action {
    protected void enableDirectoryBrowserSupport(StaplerRequest2 req, StaplerResponse2 rsp, FilePath directoryToServe) throws IOException, ServletException {
        DirectoryBrowserSupport directoryBrowser = new DirectoryBrowserSupport((ModelObject)this, directoryToServe, this.getDisplayName() + "html2", "graph.gif", false);
        SonargraphLogger.INSTANCE.log(Level.FINE, "AbstractHTMLAction.enableDirectoryBrowserSupport for directory " + directoryToServe.getRemote());
        directoryBrowser.generateResponse(req, rsp, (Object)this);
    }

    protected String readHTMLReport(FilePath pathToReport, String alternative) throws IOException, InterruptedException {
        SonargraphLogger.INSTANCE.log(Level.INFO, "Reading Sonargraph HTML Report from '" + String.valueOf(pathToReport) + "'");
        if (pathToReport.exists()) {
            return TextFileReader.readLargeTextFile(pathToReport);
        }
        SonargraphLogger.INSTANCE.log(Level.WARNING, "Unable to read Sonargraph HTML report from '" + String.valueOf(pathToReport) + "'");
        return alternative;
    }

    public abstract void doDynamic(StaplerRequest2 var1, StaplerResponse2 var2) throws IOException, ServletException;

    public abstract String getHTMLReport() throws IOException, InterruptedException;
}

