/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.slave_setup;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.slave_setup.Components;

public class Utils {
    public static String osLineSeparator(boolean isUnix) {
        return isUnix ? "\n" : "\r\n";
    }

    public static String osLineSeparator(String someFullPath) {
        Components.debug("incoming path to get OS " + someFullPath);
        return Utils.osLineSeparator(someFullPath.startsWith("/"));
    }

    public static int multiOsExecutor(TaskListener listener, String script, FilePath root, EnvVars enviroment) throws IOException, InterruptedException {
        Launcher launcher = root.createLauncher(listener);
        if (enviroment == null) {
            enviroment = new EnvVars();
        }
        if (launcher.isUnix()) {
            Shell shell = new Shell(script);
            FilePath scriptFile = shell.createScriptFile(root);
            return launcher.launch().cmds(shell.buildCommandLine(scriptFile)).pwd(root).envs((Map)enviroment).stdout(listener).join();
        }
        BatchFile batch = new BatchFile(script);
        FilePath scriptFile = batch.createScriptFile(root);
        return launcher.launch().cmds(batch.buildCommandLine(scriptFile)).pwd(root).envs((Map)enviroment).stdout(listener).join();
    }

    public static boolean labelMatches(String pattern, Computer slave) {
        Label configLabel = Label.get((String)pattern.toLowerCase());
        Node node = slave.getNode();
        if (node == null) {
            return false;
        }
        Set labels = node.getAssignedLabels();
        if (labels == null) {
            return false;
        }
        return configLabel.matches((Collection)labels);
    }

    public static String stringFy(Object obj) {
        StringBuilder result = new StringBuilder();
        try {
            Field[] fields;
            String newLine = System.getProperty("line.separator");
            result.append(obj.getClass().getName());
            result.append(" Object {");
            result.append(newLine);
            for (Field field : fields = obj.getClass().getDeclaredFields()) {
                result.append("  ");
                try {
                    result.append(field.getName());
                    result.append(": ");
                    field.setAccessible(true);
                    result.append(field.get(obj));
                }
                catch (IllegalAccessException ex) {
                    System.out.println(ex);
                }
                result.append(newLine);
            }
            result.append("}");
        }
        catch (Exception ex) {
            result.append("Unable to get attributes: " + ex.getMessage());
        }
        return result.toString();
    }

    public static List<Computer> getAllActiveSlaves() {
        List<Computer> computers = Arrays.asList(Jenkins.getInstance().getComputers());
        ArrayList<Computer> activeComputers = new ArrayList<Computer>();
        for (Computer computer : computers) {
            if (computer instanceof Jenkins.MasterComputer || !computer.isOnline()) continue;
            activeComputers.add(computer);
        }
        return activeComputers;
    }
}

